/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.floattransform;

import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.FloatMetaData;
import org.datavec.api.transform.transform.floattransform.BaseFloatTransform;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;

public class ConvertToFloat
extends BaseFloatTransform {
    public ConvertToFloat(String column) {
        super(column);
    }

    @Override
    public FloatWritable map(Writable writable) {
        if (writable.getType() == WritableType.Double) {
            return (FloatWritable)writable;
        }
        return new FloatWritable(writable.toFloat());
    }

    @Override
    public Object map(Object input) {
        if (input instanceof Number) {
            return Float.valueOf(((Number)input).floatValue());
        }
        return Float.valueOf(Float.parseFloat(input.toString()));
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newColumnName, ColumnMetaData oldColumnType) {
        return new FloatMetaData(newColumnName);
    }

    @Override
    public String toString() {
        return "ConvertToFloat(columnName=" + this.columnName + ")";
    }

    public ConvertToFloat() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertToFloat)) {
            return false;
        }
        ConvertToFloat other = (ConvertToFloat)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConvertToFloat;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

