/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.sequence;

import java.io.Serializable;
import java.util.Arrays;

public class SequenceLengthAnalysis
implements Serializable {
    private long totalNumSequences;
    private int minSeqLength;
    private int maxSeqLength;
    private long countZeroLength;
    private long countOneLength;
    private double meanLength;
    private double[] histogramBuckets;
    private long[] histogramBucketCounts;

    protected SequenceLengthAnalysis() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SequenceLengthAnalysis(").append("totalNumSequences=").append(this.totalNumSequences).append(",minSeqLength=").append(this.minSeqLength).append(",maxSeqLength=").append(this.maxSeqLength).append(",countZeroLength=").append(this.countZeroLength).append(",countOneLength=").append(this.countOneLength).append(",meanLength=").append(this.meanLength).append(")");
        return sb.toString();
    }

    public static SequenceLengthAnalysisBuilder builder() {
        return new SequenceLengthAnalysisBuilder();
    }

    public SequenceLengthAnalysis(long totalNumSequences, int minSeqLength, int maxSeqLength, long countZeroLength, long countOneLength, double meanLength, double[] histogramBuckets, long[] histogramBucketCounts) {
        this.totalNumSequences = totalNumSequences;
        this.minSeqLength = minSeqLength;
        this.maxSeqLength = maxSeqLength;
        this.countZeroLength = countZeroLength;
        this.countOneLength = countOneLength;
        this.meanLength = meanLength;
        this.histogramBuckets = histogramBuckets;
        this.histogramBucketCounts = histogramBucketCounts;
    }

    public long getTotalNumSequences() {
        return this.totalNumSequences;
    }

    public int getMinSeqLength() {
        return this.minSeqLength;
    }

    public int getMaxSeqLength() {
        return this.maxSeqLength;
    }

    public long getCountZeroLength() {
        return this.countZeroLength;
    }

    public long getCountOneLength() {
        return this.countOneLength;
    }

    public double getMeanLength() {
        return this.meanLength;
    }

    public double[] getHistogramBuckets() {
        return this.histogramBuckets;
    }

    public long[] getHistogramBucketCounts() {
        return this.histogramBucketCounts;
    }

    public void setTotalNumSequences(long totalNumSequences) {
        this.totalNumSequences = totalNumSequences;
    }

    public void setMinSeqLength(int minSeqLength) {
        this.minSeqLength = minSeqLength;
    }

    public void setMaxSeqLength(int maxSeqLength) {
        this.maxSeqLength = maxSeqLength;
    }

    public void setCountZeroLength(long countZeroLength) {
        this.countZeroLength = countZeroLength;
    }

    public void setCountOneLength(long countOneLength) {
        this.countOneLength = countOneLength;
    }

    public void setMeanLength(double meanLength) {
        this.meanLength = meanLength;
    }

    public void setHistogramBuckets(double[] histogramBuckets) {
        this.histogramBuckets = histogramBuckets;
    }

    public void setHistogramBucketCounts(long[] histogramBucketCounts) {
        this.histogramBucketCounts = histogramBucketCounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceLengthAnalysis)) {
            return false;
        }
        SequenceLengthAnalysis other = (SequenceLengthAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalNumSequences() != other.getTotalNumSequences()) {
            return false;
        }
        if (this.getMinSeqLength() != other.getMinSeqLength()) {
            return false;
        }
        if (this.getMaxSeqLength() != other.getMaxSeqLength()) {
            return false;
        }
        if (this.getCountZeroLength() != other.getCountZeroLength()) {
            return false;
        }
        if (this.getCountOneLength() != other.getCountOneLength()) {
            return false;
        }
        if (Double.compare(this.getMeanLength(), other.getMeanLength()) != 0) {
            return false;
        }
        if (!Arrays.equals(this.getHistogramBuckets(), other.getHistogramBuckets())) {
            return false;
        }
        return Arrays.equals(this.getHistogramBucketCounts(), other.getHistogramBucketCounts());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceLengthAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalNumSequences = this.getTotalNumSequences();
        result = result * 59 + (int)($totalNumSequences >>> 32 ^ $totalNumSequences);
        result = result * 59 + this.getMinSeqLength();
        result = result * 59 + this.getMaxSeqLength();
        long $countZeroLength = this.getCountZeroLength();
        result = result * 59 + (int)($countZeroLength >>> 32 ^ $countZeroLength);
        long $countOneLength = this.getCountOneLength();
        result = result * 59 + (int)($countOneLength >>> 32 ^ $countOneLength);
        long $meanLength = Double.doubleToLongBits(this.getMeanLength());
        result = result * 59 + (int)($meanLength >>> 32 ^ $meanLength);
        result = result * 59 + Arrays.hashCode(this.getHistogramBuckets());
        result = result * 59 + Arrays.hashCode(this.getHistogramBucketCounts());
        return result;
    }

    public static class SequenceLengthAnalysisBuilder {
        private long totalNumSequences;
        private int minSeqLength;
        private int maxSeqLength;
        private long countZeroLength;
        private long countOneLength;
        private double meanLength;
        private double[] histogramBuckets;
        private long[] histogramBucketCounts;

        SequenceLengthAnalysisBuilder() {
        }

        public SequenceLengthAnalysisBuilder totalNumSequences(long totalNumSequences) {
            this.totalNumSequences = totalNumSequences;
            return this;
        }

        public SequenceLengthAnalysisBuilder minSeqLength(int minSeqLength) {
            this.minSeqLength = minSeqLength;
            return this;
        }

        public SequenceLengthAnalysisBuilder maxSeqLength(int maxSeqLength) {
            this.maxSeqLength = maxSeqLength;
            return this;
        }

        public SequenceLengthAnalysisBuilder countZeroLength(long countZeroLength) {
            this.countZeroLength = countZeroLength;
            return this;
        }

        public SequenceLengthAnalysisBuilder countOneLength(long countOneLength) {
            this.countOneLength = countOneLength;
            return this;
        }

        public SequenceLengthAnalysisBuilder meanLength(double meanLength) {
            this.meanLength = meanLength;
            return this;
        }

        public SequenceLengthAnalysisBuilder histogramBuckets(double[] histogramBuckets) {
            this.histogramBuckets = histogramBuckets;
            return this;
        }

        public SequenceLengthAnalysisBuilder histogramBucketCounts(long[] histogramBucketCounts) {
            this.histogramBucketCounts = histogramBucketCounts;
            return this;
        }

        public SequenceLengthAnalysis build() {
            return new SequenceLengthAnalysis(this.totalNumSequences, this.minSeqLength, this.maxSeqLength, this.countZeroLength, this.countOneLength, this.meanLength, this.histogramBuckets, this.histogramBucketCounts);
        }

        public String toString() {
            return "SequenceLengthAnalysis.SequenceLengthAnalysisBuilder(totalNumSequences=" + this.totalNumSequences + ", minSeqLength=" + this.minSeqLength + ", maxSeqLength=" + this.maxSeqLength + ", countZeroLength=" + this.countZeroLength + ", countOneLength=" + this.countOneLength + ", meanLength=" + this.meanLength + ", histogramBuckets=" + Arrays.toString(this.histogramBuckets) + ", histogramBucketCounts=" + Arrays.toString(this.histogramBucketCounts) + ")";
        }
    }
}

