/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.columns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;

public class NDArrayAnalysis
implements ColumnAnalysis {
    private long countTotal;
    private long countNull;
    private long minLength;
    private long maxLength;
    private long totalNDArrayValues;
    private Map<Integer, Long> countsByRank;
    private double minValue;
    private double maxValue;
    protected double[] histogramBuckets;
    protected long[] histogramBucketCounts;

    @Override
    public ColumnType getColumnType() {
        return ColumnType.NDArray;
    }

    public String toString() {
        LinkedHashMap<Integer, Long> sortedCountsByRank = new LinkedHashMap<Integer, Long>();
        ArrayList keys = new ArrayList(this.countsByRank == null ? Collections.emptySet() : this.countsByRank.keySet());
        Collections.sort(keys);
        for (Integer i : keys) {
            sortedCountsByRank.put(i, this.countsByRank.get(i));
        }
        return "NDArrayAnalysis(countTotal=" + this.countTotal + ",countNull=" + this.countNull + ",minLength=" + this.minLength + ",maxLength=" + this.maxLength + ",totalValuesAllNDArrays=" + this.totalNDArrayValues + ",minValue=" + this.minValue + ",maxValue=" + this.maxValue + ",countsByNDArrayRank=" + sortedCountsByRank + ")";
    }

    public static Builder Builder() {
        return new Builder();
    }

    public NDArrayAnalysis(long countTotal, long countNull, long minLength, long maxLength, long totalNDArrayValues, Map<Integer, Long> countsByRank, double minValue, double maxValue, double[] histogramBuckets, long[] histogramBucketCounts) {
        this.countTotal = countTotal;
        this.countNull = countNull;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.totalNDArrayValues = totalNDArrayValues;
        this.countsByRank = countsByRank;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.histogramBuckets = histogramBuckets;
        this.histogramBucketCounts = histogramBucketCounts;
    }

    public NDArrayAnalysis() {
    }

    @Override
    public long getCountTotal() {
        return this.countTotal;
    }

    public long getCountNull() {
        return this.countNull;
    }

    public long getMinLength() {
        return this.minLength;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public long getTotalNDArrayValues() {
        return this.totalNDArrayValues;
    }

    public Map<Integer, Long> getCountsByRank() {
        return this.countsByRank;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double[] getHistogramBuckets() {
        return this.histogramBuckets;
    }

    public long[] getHistogramBucketCounts() {
        return this.histogramBucketCounts;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public void setCountNull(long countNull) {
        this.countNull = countNull;
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    public void setTotalNDArrayValues(long totalNDArrayValues) {
        this.totalNDArrayValues = totalNDArrayValues;
    }

    public void setCountsByRank(Map<Integer, Long> countsByRank) {
        this.countsByRank = countsByRank;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setHistogramBuckets(double[] histogramBuckets) {
        this.histogramBuckets = histogramBuckets;
    }

    public void setHistogramBucketCounts(long[] histogramBucketCounts) {
        this.histogramBucketCounts = histogramBucketCounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDArrayAnalysis)) {
            return false;
        }
        NDArrayAnalysis other = (NDArrayAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountTotal() != other.getCountTotal()) {
            return false;
        }
        if (this.getCountNull() != other.getCountNull()) {
            return false;
        }
        if (this.getMinLength() != other.getMinLength()) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        if (this.getTotalNDArrayValues() != other.getTotalNDArrayValues()) {
            return false;
        }
        Map<Integer, Long> this$countsByRank = this.getCountsByRank();
        Map<Integer, Long> other$countsByRank = other.getCountsByRank();
        if (this$countsByRank == null ? other$countsByRank != null : !((Object)this$countsByRank).equals(other$countsByRank)) {
            return false;
        }
        if (Double.compare(this.getMinValue(), other.getMinValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxValue(), other.getMaxValue()) != 0) {
            return false;
        }
        if (!Arrays.equals(this.getHistogramBuckets(), other.getHistogramBuckets())) {
            return false;
        }
        return Arrays.equals(this.getHistogramBucketCounts(), other.getHistogramBucketCounts());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NDArrayAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        long $countNull = this.getCountNull();
        result = result * 59 + (int)($countNull >>> 32 ^ $countNull);
        long $minLength = this.getMinLength();
        result = result * 59 + (int)($minLength >>> 32 ^ $minLength);
        long $maxLength = this.getMaxLength();
        result = result * 59 + (int)($maxLength >>> 32 ^ $maxLength);
        long $totalNDArrayValues = this.getTotalNDArrayValues();
        result = result * 59 + (int)($totalNDArrayValues >>> 32 ^ $totalNDArrayValues);
        Map<Integer, Long> $countsByRank = this.getCountsByRank();
        result = result * 59 + ($countsByRank == null ? 43 : ((Object)$countsByRank).hashCode());
        long $minValue = Double.doubleToLongBits(this.getMinValue());
        result = result * 59 + (int)($minValue >>> 32 ^ $minValue);
        long $maxValue = Double.doubleToLongBits(this.getMaxValue());
        result = result * 59 + (int)($maxValue >>> 32 ^ $maxValue);
        result = result * 59 + Arrays.hashCode(this.getHistogramBuckets());
        result = result * 59 + Arrays.hashCode(this.getHistogramBucketCounts());
        return result;
    }

    public static class Builder {
        private long countTotal;
        private long countNull;
        private long minLength;
        private long maxLength;
        private long totalNDArrayValues;
        private Map<Integer, Long> countsByRank;
        private double minValue;
        private double maxValue;
        private double[] histogramBuckets;
        private long[] histogramBucketCounts;

        Builder() {
        }

        public Builder countTotal(long countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        public Builder countNull(long countNull) {
            this.countNull = countNull;
            return this;
        }

        public Builder minLength(long minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder maxLength(long maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder totalNDArrayValues(long totalNDArrayValues) {
            this.totalNDArrayValues = totalNDArrayValues;
            return this;
        }

        public Builder countsByRank(Map<Integer, Long> countsByRank) {
            this.countsByRank = countsByRank;
            return this;
        }

        public Builder minValue(double minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder maxValue(double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder histogramBuckets(double[] histogramBuckets) {
            this.histogramBuckets = histogramBuckets;
            return this;
        }

        public Builder histogramBucketCounts(long[] histogramBucketCounts) {
            this.histogramBucketCounts = histogramBucketCounts;
            return this;
        }

        public NDArrayAnalysis build() {
            return new NDArrayAnalysis(this.countTotal, this.countNull, this.minLength, this.maxLength, this.totalNDArrayValues, this.countsByRank, this.minValue, this.maxValue, this.histogramBuckets, this.histogramBucketCounts);
        }

        public String toString() {
            return "NDArrayAnalysis.Builder(countTotal=" + this.countTotal + ", countNull=" + this.countNull + ", minLength=" + this.minLength + ", maxLength=" + this.maxLength + ", totalNDArrayValues=" + this.totalNDArrayValues + ", countsByRank=" + this.countsByRank + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", histogramBuckets=" + Arrays.toString(this.histogramBuckets) + ", histogramBucketCounts=" + Arrays.toString(this.histogramBucketCounts) + ")";
        }
    }
}

