/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.datavec.api.records.listener.RecordListener;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.StreamInputSplit;
import org.datavec.api.split.streams.FileStreamCreatorFunction;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.function.Function;

public abstract class BaseRecordReader
implements RecordReader {
    protected InputSplit inputSplit;
    protected List<RecordListener> listeners = new ArrayList<RecordListener>();
    protected Function<URI, InputStream> streamCreatorFn = new FileStreamCreatorFunction();

    protected void invokeListeners(Object record) {
        for (RecordListener listener : this.listeners) {
            listener.recordRead(this, record);
        }
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        StreamInputSplit s;
        this.inputSplit = split;
        if (split instanceof StreamInputSplit && (s = (StreamInputSplit)split).getStreamCreatorFn() != null) {
            this.streamCreatorFn = s.getStreamCreatorFn();
        }
    }

    @Override
    public List<RecordListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void setListeners(Collection<RecordListener> listeners) {
        this.listeners = listeners instanceof List ? (List<Object>)listeners : new ArrayList<RecordListener>(listeners);
    }

    @Override
    public void setListeners(RecordListener ... listeners) {
        this.setListeners(Arrays.asList(listeners));
    }

    @Override
    public boolean batchesSupported() {
        return false;
    }

    @Override
    public List<List<Writable>> next(int num) {
        throw new UnsupportedOperationException();
    }
}

