/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util.files;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class URIUtil {
    public static URI fileToURI(File f) {
        try {
            Object sp = URIUtil.slashify(f.getAbsoluteFile().getPath(), false);
            if (!((String)sp).startsWith("//")) {
                sp = "//" + (String)sp;
            }
            return new URI("file", null, (String)sp, null);
        }
        catch (URISyntaxException x) {
            throw new Error(x);
        }
    }

    private static String slashify(String path, boolean isDirectory) {
        Object p = path;
        if (File.separatorChar != '/') {
            p = ((String)p).replace(File.separatorChar, '/');
        }
        if (!((String)p).startsWith("/")) {
            p = "/" + (String)p;
        }
        if (!((String)p).endsWith("/") && isDirectory) {
            p = (String)p + "/";
        }
        return p;
    }
}

