/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.transform.string.StringListToCountsNDArrayTransform;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class StringListToIndicesNDArrayTransform
extends StringListToCountsNDArrayTransform {
    public StringListToIndicesNDArrayTransform(String columnName, List<String> vocabulary, String delimiter, boolean binary, boolean ignoreUnknown) {
        super(columnName, vocabulary, delimiter, binary, ignoreUnknown);
    }

    public StringListToIndicesNDArrayTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="vocabulary") List<String> vocabulary, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="binary") boolean binary, @JsonProperty(value="ignoreUnknown") boolean ignoreUnknown) {
        super(columnName, newColumnName, vocabulary, delimiter, binary, ignoreUnknown);
    }

    @Override
    protected INDArray makeBOWNDArray(Collection<Integer> indices) {
        INDArray counts = Nd4j.zeros((int[])new int[]{1, indices.size()});
        ArrayList<Integer> indicesSorted = new ArrayList<Integer>(indices);
        Collections.sort(indicesSorted);
        for (int i = 0; i < indicesSorted.size(); ++i) {
            counts.putScalar((long)i, ((Integer)indicesSorted.get(i)).intValue());
        }
        Nd4j.getExecutioner().commit();
        return counts;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringListToIndicesNDArrayTransform)) {
            return false;
        }
        StringListToIndicesNDArrayTransform other = (StringListToIndicesNDArrayTransform)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StringListToIndicesNDArrayTransform;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    public String toString() {
        return "StringListToIndicesNDArrayTransform()";
    }
}

