/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.transform.string.BaseStringTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class MapAllStringsExceptListTransform
extends BaseStringTransform {
    private final Set<String> exceptions;
    private final String newValue;

    public MapAllStringsExceptListTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="newValue") String newValue, @JsonProperty(value="exceptions") List<String> exceptions) {
        super(columnName);
        this.newValue = newValue;
        this.exceptions = new HashSet<String>(exceptions);
    }

    @Override
    public Text map(Writable writable) {
        String str = writable.toString();
        if (this.exceptions.contains(str)) {
            return new Text(str);
        }
        return new Text(this.newValue);
    }

    @Override
    public Object map(Object input) {
        String str = input.toString();
        if (this.exceptions.contains(str)) {
            return str;
        }
        return this.newValue;
    }

    public Set<String> getExceptions() {
        return this.exceptions;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @Override
    public String toString() {
        return "MapAllStringsExceptListTransform(exceptions=" + this.getExceptions() + ", newValue=" + this.getNewValue() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapAllStringsExceptListTransform)) {
            return false;
        }
        MapAllStringsExceptListTransform other = (MapAllStringsExceptListTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$exceptions = this.getExceptions();
        Set<String> other$exceptions = other.getExceptions();
        if (this$exceptions == null ? other$exceptions != null : !((Object)this$exceptions).equals(other$exceptions)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MapAllStringsExceptListTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $exceptions = this.getExceptions();
        result = result * 59 + ($exceptions == null ? 43 : ((Object)$exceptions).hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }
}

