/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.integer;

import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class IntegerMathOpTransform
extends BaseColumnTransform {
    private final MathOp mathOp;
    private final int scalar;

    public IntegerMathOpTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mathOp") MathOp mathOp, @JsonProperty(value="scalar") int scalar) {
        super(columnName);
        this.mathOp = mathOp;
        this.scalar = scalar;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newColumnName, ColumnMetaData oldColumnType) {
        if (!(oldColumnType instanceof IntegerMetaData)) {
            throw new IllegalStateException("Column is not an integer column");
        }
        IntegerMetaData meta = (IntegerMetaData)oldColumnType;
        Integer minValue = meta.getMinAllowedValue();
        Integer maxValue = meta.getMaxAllowedValue();
        if (minValue != null) {
            minValue = this.doOp(minValue);
        }
        if (maxValue != null) {
            maxValue = this.doOp(maxValue);
        }
        if (minValue != null && maxValue != null && minValue > maxValue) {
            Integer temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        return new IntegerMetaData(newColumnName, minValue, maxValue);
    }

    private int doOp(int input) {
        switch (this.mathOp) {
            case Add: {
                return input + this.scalar;
            }
            case Subtract: {
                return input - this.scalar;
            }
            case Multiply: {
                return input * this.scalar;
            }
            case Divide: {
                return input / this.scalar;
            }
            case Modulus: {
                return input % this.scalar;
            }
            case ReverseSubtract: {
                return this.scalar - input;
            }
            case ReverseDivide: {
                return this.scalar / input;
            }
            case ScalarMin: {
                return Math.min(input, this.scalar);
            }
            case ScalarMax: {
                return Math.max(input, this.scalar);
            }
        }
        throw new IllegalStateException("Unknown or not implemented math op: " + this.mathOp);
    }

    @Override
    public Writable map(Writable columnWritable) {
        return new IntWritable(this.doOp(columnWritable.toInt()));
    }

    @Override
    public String toString() {
        return "IntegerMathOpTransform(mathOp=" + this.mathOp + ",scalar=" + this.scalar + ")";
    }

    @Override
    public Object map(Object input) {
        Number n = (Number)input;
        return this.doOp(n.intValue());
    }

    public MathOp getMathOp() {
        return this.mathOp;
    }

    public int getScalar() {
        return this.scalar;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerMathOpTransform)) {
            return false;
        }
        IntegerMathOpTransform other = (IntegerMathOpTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScalar() != other.getScalar()) {
            return false;
        }
        MathOp this$mathOp = this.getMathOp();
        MathOp other$mathOp = other.getMathOp();
        return !(this$mathOp == null ? other$mathOp != null : !((Object)((Object)this$mathOp)).equals((Object)other$mathOp));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IntegerMathOpTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getScalar();
        MathOp $mathOp = this.getMathOp();
        result = result * 59 + ($mathOp == null ? 43 : ((Object)((Object)$mathOp)).hashCode());
        return result;
    }
}

