/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.floattransform;

import org.datavec.api.transform.MathFunction;
import org.datavec.api.transform.transform.floattransform.BaseFloatTransform;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FloatMathFunctionTransform
extends BaseFloatTransform {
    private MathFunction mathFunction;

    public FloatMathFunctionTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mathFunction") MathFunction mathFunction) {
        super(columnName);
        this.mathFunction = mathFunction;
    }

    @Override
    public Writable map(Writable w) {
        switch (this.mathFunction) {
            case ABS: {
                return new FloatWritable(Math.abs(w.toFloat()));
            }
            case ACOS: {
                return new FloatWritable((float)Math.acos(w.toFloat()));
            }
            case ASIN: {
                return new FloatWritable((float)Math.asin(w.toFloat()));
            }
            case ATAN: {
                return new FloatWritable((float)Math.atan(w.toFloat()));
            }
            case CEIL: {
                return new FloatWritable((float)Math.ceil(w.toFloat()));
            }
            case COS: {
                return new FloatWritable((float)Math.cos(w.toFloat()));
            }
            case COSH: {
                return new FloatWritable((float)Math.cosh(w.toFloat()));
            }
            case EXP: {
                return new FloatWritable((float)Math.exp(w.toFloat()));
            }
            case FLOOR: {
                return new FloatWritable((float)Math.floor(w.toFloat()));
            }
            case LOG: {
                return new FloatWritable((float)Math.log(w.toFloat()));
            }
            case LOG10: {
                return new FloatWritable((float)Math.log10(w.toFloat()));
            }
            case SIGNUM: {
                return new FloatWritable(Math.signum(w.toFloat()));
            }
            case SIN: {
                return new FloatWritable((float)Math.sin(w.toFloat()));
            }
            case SINH: {
                return new FloatWritable((float)Math.sinh(w.toFloat()));
            }
            case SQRT: {
                return new FloatWritable((float)Math.sqrt(w.toFloat()));
            }
            case TAN: {
                return new FloatWritable((float)Math.tan(w.toFloat()));
            }
            case TANH: {
                return new FloatWritable((float)Math.tanh(w.toFloat()));
            }
        }
        throw new RuntimeException("Unknown function: " + this.mathFunction);
    }

    @Override
    public Object map(Object input) {
        Float d = Float.valueOf(((Number)input).floatValue());
        switch (this.mathFunction) {
            case ABS: {
                return Float.valueOf(Math.abs(d.floatValue()));
            }
            case ACOS: {
                return Math.acos(d.floatValue());
            }
            case ASIN: {
                return Math.asin(d.floatValue());
            }
            case ATAN: {
                return Math.atan(d.floatValue());
            }
            case CEIL: {
                return Math.ceil(d.floatValue());
            }
            case COS: {
                return Math.cos(d.floatValue());
            }
            case COSH: {
                return Math.cosh(d.floatValue());
            }
            case EXP: {
                return Math.exp(d.floatValue());
            }
            case FLOOR: {
                return Math.floor(d.floatValue());
            }
            case LOG: {
                return Math.log(d.floatValue());
            }
            case LOG10: {
                return Math.log10(d.floatValue());
            }
            case SIGNUM: {
                return Float.valueOf(Math.signum(d.floatValue()));
            }
            case SIN: {
                return Math.sin(d.floatValue());
            }
            case SINH: {
                return Math.sinh(d.floatValue());
            }
            case SQRT: {
                return Math.sqrt(d.floatValue());
            }
            case TAN: {
                return Math.tan(d.floatValue());
            }
            case TANH: {
                return Math.tanh(d.floatValue());
            }
        }
        throw new RuntimeException("Unknown function: " + this.mathFunction);
    }

    public MathFunction getMathFunction() {
        return this.mathFunction;
    }

    public void setMathFunction(MathFunction mathFunction) {
        this.mathFunction = mathFunction;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatMathFunctionTransform)) {
            return false;
        }
        FloatMathFunctionTransform other = (FloatMathFunctionTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MathFunction this$mathFunction = this.getMathFunction();
        MathFunction other$mathFunction = other.getMathFunction();
        return !(this$mathFunction == null ? other$mathFunction != null : !((Object)((Object)this$mathFunction)).equals((Object)other$mathFunction));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FloatMathFunctionTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MathFunction $mathFunction = this.getMathFunction();
        result = result * 59 + ($mathFunction == null ? 43 : ((Object)((Object)$mathFunction)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FloatMathFunctionTransform(mathFunction=" + this.getMathFunction() + ")";
    }
}

