/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.condition;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnOp;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"columnToReplaceIdx", "sourceColumnIdx"})
public class ConditionalCopyValueTransform
implements Transform,
ColumnOp {
    private final String columnToReplace;
    private final String sourceColumn;
    private final Condition condition;
    private int columnToReplaceIdx = -1;
    private int sourceColumnIdx = -1;

    public ConditionalCopyValueTransform(@JsonProperty(value="columnToReplace") String columnToReplace, @JsonProperty(value="sourceColumn") String sourceColumn, @JsonProperty(value="condition") Condition condition) {
        this.columnToReplace = columnToReplace;
        this.sourceColumn = sourceColumn;
        this.condition = condition;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        return inputSchema;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        if (!inputSchema.hasColumn(this.columnToReplace)) {
            throw new IllegalStateException("Column \"" + this.columnToReplace + "\" not found in input schema");
        }
        if (!inputSchema.hasColumn(this.sourceColumn)) {
            throw new IllegalStateException("Column \"" + this.sourceColumn + "\" not found in input schema");
        }
        this.columnToReplaceIdx = inputSchema.getIndexOfColumn(this.columnToReplace);
        this.sourceColumnIdx = inputSchema.getIndexOfColumn(this.sourceColumn);
        this.condition.setInputSchema(inputSchema);
    }

    @Override
    public Schema getInputSchema() {
        return this.condition.getInputSchema();
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (this.condition.condition(writables)) {
            ArrayList<Writable> newList = new ArrayList<Writable>(writables);
            newList.set(this.columnToReplaceIdx, writables.get(this.sourceColumnIdx));
            return newList;
        }
        return writables;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (List<Writable> step : sequence) {
            out.add(this.map(step));
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        return null;
    }

    @Override
    public Object mapSequence(Object sequence) {
        List seq = (List)sequence;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object step : seq) {
            ret.add(this.map(step));
        }
        return ret;
    }

    public String toString() {
        return "ConditionalCopyValueTransform(replaceColumn=\"" + this.columnToReplace + "\",sourceColumn=" + this.sourceColumn + ",condition=" + this.condition + ")";
    }

    @Override
    public String outputColumnName() {
        return this.columnToReplace;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.columnToReplace};
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.columnName()};
    }

    @Override
    public String columnName() {
        return this.sourceColumn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionalCopyValueTransform)) {
            return false;
        }
        ConditionalCopyValueTransform other = (ConditionalCopyValueTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$columnToReplace = this.getColumnToReplace();
        String other$columnToReplace = other.getColumnToReplace();
        if (this$columnToReplace == null ? other$columnToReplace != null : !this$columnToReplace.equals(other$columnToReplace)) {
            return false;
        }
        String this$sourceColumn = this.getSourceColumn();
        String other$sourceColumn = other.getSourceColumn();
        if (this$sourceColumn == null ? other$sourceColumn != null : !this$sourceColumn.equals(other$sourceColumn)) {
            return false;
        }
        Condition this$condition = this.getCondition();
        Condition other$condition = other.getCondition();
        return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConditionalCopyValueTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnToReplace = this.getColumnToReplace();
        result = result * 59 + ($columnToReplace == null ? 43 : $columnToReplace.hashCode());
        String $sourceColumn = this.getSourceColumn();
        result = result * 59 + ($sourceColumn == null ? 43 : $sourceColumn.hashCode());
        Condition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        return result;
    }

    public String getColumnToReplace() {
        return this.columnToReplace;
    }

    public String getSourceColumn() {
        return this.sourceColumn;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public int getColumnToReplaceIdx() {
        return this.columnToReplaceIdx;
    }

    public int getSourceColumnIdx() {
        return this.sourceColumnIdx;
    }

    public void setColumnToReplaceIdx(int columnToReplaceIdx) {
        this.columnToReplaceIdx = columnToReplaceIdx;
    }

    public void setSourceColumnIdx(int sourceColumnIdx) {
        this.sourceColumnIdx = sourceColumnIdx;
    }
}

