/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.window;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.transform.sequence.window.WindowFunction;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.joda.time.DateTimeZone;

public class TimeWindowFunction
implements WindowFunction {
    private final String timeColumn;
    private final long windowSize;
    private final TimeUnit windowSizeUnit;
    private final long offsetAmount;
    private final TimeUnit offsetUnit;
    private final boolean addWindowStartTimeColumn;
    private final boolean addWindowEndTimeColumn;
    private final boolean excludeEmptyWindows;
    private Schema inputSchema;
    private final long offsetAmountMilliseconds;
    private final long windowSizeMilliseconds;
    private DateTimeZone timeZone;

    public TimeWindowFunction(String timeColumn, long windowSize, TimeUnit windowSizeUnit) {
        this(timeColumn, windowSize, windowSizeUnit, 0L, null);
    }

    public TimeWindowFunction(String timeColumn, long windowSize, TimeUnit windowSizeUnit, boolean addWindowStartTimeColumn, boolean addWindowEndTimeColumn) {
        this(timeColumn, windowSize, windowSizeUnit, 0L, null, addWindowStartTimeColumn, addWindowEndTimeColumn, false);
    }

    public TimeWindowFunction(String timeColumn, long windowSize, TimeUnit windowSizeUnit, long offset, TimeUnit offsetUnit) {
        this(timeColumn, windowSize, windowSizeUnit, offset, offsetUnit, false, false, false);
    }

    public TimeWindowFunction(String timeColumn, long windowSize, TimeUnit windowSizeUnit, long offset, TimeUnit offsetUnit, boolean addWindowStartTimeColumn, boolean addWindowEndTimeColumn, boolean excludeEmptyWindows) {
        this.timeColumn = timeColumn;
        this.windowSize = windowSize;
        this.windowSizeUnit = windowSizeUnit;
        this.offsetAmount = offset;
        this.offsetUnit = offsetUnit;
        this.addWindowStartTimeColumn = addWindowStartTimeColumn;
        this.addWindowEndTimeColumn = addWindowEndTimeColumn;
        this.excludeEmptyWindows = excludeEmptyWindows;
        this.offsetAmountMilliseconds = this.offsetAmount == 0L || offsetUnit == null ? 0L : TimeUnit.MILLISECONDS.convert(offset, offsetUnit);
        this.windowSizeMilliseconds = TimeUnit.MILLISECONDS.convert(windowSize, windowSizeUnit);
    }

    private TimeWindowFunction(Builder builder) {
        this(builder.timeColumn, builder.windowSize, builder.windowSizeUnit, builder.offsetAmount, builder.offsetUnit, builder.addWindowStartTimeColumn, builder.addWindowEndTimeColumn, builder.excludeEmptyWindows);
    }

    @Override
    public void setInputSchema(Schema schema) {
        if (!(schema instanceof SequenceSchema)) {
            throw new IllegalArgumentException("Invalid schema: TimeWindowFunction can only operate on SequenceSchema");
        }
        if (!schema.hasColumn(this.timeColumn)) {
            throw new IllegalStateException("Input schema does not have a column with name \"" + this.timeColumn + "\"");
        }
        if (schema.getMetaData(this.timeColumn).getColumnType() != ColumnType.Time) {
            throw new IllegalStateException("Invalid column: column \"" + this.timeColumn + "\" is not of type " + ColumnType.Time + "; is " + schema.getMetaData(this.timeColumn).getColumnType());
        }
        this.inputSchema = schema;
        this.timeZone = ((TimeMetaData)schema.getMetaData(this.timeColumn)).getTimeZone();
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        if (!this.addWindowStartTimeColumn && !this.addWindowEndTimeColumn) {
            return inputSchema;
        }
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(inputSchema.getColumnMetaData());
        if (this.addWindowStartTimeColumn) {
            newMeta.add(new TimeMetaData("windowStartTime"));
        }
        if (this.addWindowEndTimeColumn) {
            newMeta.add(new TimeMetaData("windowEndTime"));
        }
        return inputSchema.newSchema(newMeta);
    }

    public String toString() {
        return "TimeWindowFunction(column=\"" + this.timeColumn + "\",windowSize=" + this.windowSize + this.windowSizeUnit + ",offset=" + this.offsetAmount + (Serializable)(this.offsetAmount != 0L && this.offsetUnit != null ? this.offsetUnit : "") + (this.addWindowStartTimeColumn ? ",addWindowStartTimeColumn=true" : "") + (this.addWindowEndTimeColumn ? ",addWindowEndTimeColumn=true" : "") + (this.excludeEmptyWindows ? ",excludeEmptyWindows=true" : "") + ")";
    }

    @Override
    public List<List<List<Writable>>> applyToSequence(List<List<Writable>> sequence) {
        int timeColumnIdx = this.inputSchema.getIndexOfColumn(this.timeColumn);
        ArrayList<List<List<Writable>>> out = new ArrayList<List<List<Writable>>>();
        long currentWindowStartTime = Long.MIN_VALUE;
        ArrayList<List<Writable>> currentWindow = null;
        for (List<Writable> timeStep : sequence) {
            long currentTime = timeStep.get(timeColumnIdx).toLong();
            long windowStartTimeOfThisTimeStep = this.getWindowStartTimeForTime(currentTime);
            if (currentWindowStartTime == Long.MIN_VALUE) {
                currentWindowStartTime = windowStartTimeOfThisTimeStep;
                currentWindow = new ArrayList<List<Writable>>();
            }
            if (currentWindowStartTime < windowStartTimeOfThisTimeStep) {
                while (currentWindowStartTime < windowStartTimeOfThisTimeStep) {
                    if (!(currentWindow == null || this.excludeEmptyWindows && currentWindow.size() == 0)) {
                        out.add(currentWindow);
                    }
                    currentWindow = new ArrayList();
                    currentWindowStartTime += this.windowSizeMilliseconds;
                }
            }
            if (this.addWindowStartTimeColumn || this.addWindowEndTimeColumn) {
                ArrayList<Writable> timeStep2 = new ArrayList<Writable>(timeStep);
                if (this.addWindowStartTimeColumn) {
                    timeStep2.add(new LongWritable(currentWindowStartTime));
                }
                if (this.addWindowEndTimeColumn) {
                    timeStep2.add(new LongWritable(currentWindowStartTime + this.windowSizeMilliseconds));
                }
                currentWindow.add(timeStep2);
                continue;
            }
            currentWindow.add(timeStep);
        }
        if (!(this.excludeEmptyWindows && currentWindow.size() == 0 || currentWindow == null)) {
            out.add((List<List<Writable>>)currentWindow);
        }
        return out;
    }

    public long getWindowStartTimeForTime(long time) {
        long aggregateOffset = ((long)this.timeZone.getOffset(time) + this.offsetAmountMilliseconds) % this.windowSizeMilliseconds;
        return time + aggregateOffset - (time + aggregateOffset) % this.windowSizeMilliseconds;
    }

    public long getWindowEndTimeForTime(long time) {
        return this.getWindowStartTimeForTime(time) + this.windowSizeMilliseconds;
    }

    public String getTimeColumn() {
        return this.timeColumn;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    public TimeUnit getWindowSizeUnit() {
        return this.windowSizeUnit;
    }

    public long getOffsetAmount() {
        return this.offsetAmount;
    }

    public TimeUnit getOffsetUnit() {
        return this.offsetUnit;
    }

    public boolean isAddWindowStartTimeColumn() {
        return this.addWindowStartTimeColumn;
    }

    public boolean isAddWindowEndTimeColumn() {
        return this.addWindowEndTimeColumn;
    }

    public boolean isExcludeEmptyWindows() {
        return this.excludeEmptyWindows;
    }

    public long getOffsetAmountMilliseconds() {
        return this.offsetAmountMilliseconds;
    }

    public long getWindowSizeMilliseconds() {
        return this.windowSizeMilliseconds;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeWindowFunction)) {
            return false;
        }
        TimeWindowFunction other = (TimeWindowFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowSize() != other.getWindowSize()) {
            return false;
        }
        if (this.getOffsetAmount() != other.getOffsetAmount()) {
            return false;
        }
        if (this.isAddWindowStartTimeColumn() != other.isAddWindowStartTimeColumn()) {
            return false;
        }
        if (this.isAddWindowEndTimeColumn() != other.isAddWindowEndTimeColumn()) {
            return false;
        }
        if (this.isExcludeEmptyWindows() != other.isExcludeEmptyWindows()) {
            return false;
        }
        if (this.getOffsetAmountMilliseconds() != other.getOffsetAmountMilliseconds()) {
            return false;
        }
        if (this.getWindowSizeMilliseconds() != other.getWindowSizeMilliseconds()) {
            return false;
        }
        String this$timeColumn = this.getTimeColumn();
        String other$timeColumn = other.getTimeColumn();
        if (this$timeColumn == null ? other$timeColumn != null : !this$timeColumn.equals(other$timeColumn)) {
            return false;
        }
        TimeUnit this$windowSizeUnit = this.getWindowSizeUnit();
        TimeUnit other$windowSizeUnit = other.getWindowSizeUnit();
        if (this$windowSizeUnit == null ? other$windowSizeUnit != null : !((Object)((Object)this$windowSizeUnit)).equals((Object)other$windowSizeUnit)) {
            return false;
        }
        TimeUnit this$offsetUnit = this.getOffsetUnit();
        TimeUnit other$offsetUnit = other.getOffsetUnit();
        if (this$offsetUnit == null ? other$offsetUnit != null : !((Object)((Object)this$offsetUnit)).equals((Object)other$offsetUnit)) {
            return false;
        }
        Schema this$inputSchema = this.getInputSchema();
        Schema other$inputSchema = other.getInputSchema();
        if (this$inputSchema == null ? other$inputSchema != null : !((Object)this$inputSchema).equals(other$inputSchema)) {
            return false;
        }
        DateTimeZone this$timeZone = this.getTimeZone();
        DateTimeZone other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeWindowFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $windowSize = this.getWindowSize();
        result = result * 59 + (int)($windowSize >>> 32 ^ $windowSize);
        long $offsetAmount = this.getOffsetAmount();
        result = result * 59 + (int)($offsetAmount >>> 32 ^ $offsetAmount);
        result = result * 59 + (this.isAddWindowStartTimeColumn() ? 79 : 97);
        result = result * 59 + (this.isAddWindowEndTimeColumn() ? 79 : 97);
        result = result * 59 + (this.isExcludeEmptyWindows() ? 79 : 97);
        long $offsetAmountMilliseconds = this.getOffsetAmountMilliseconds();
        result = result * 59 + (int)($offsetAmountMilliseconds >>> 32 ^ $offsetAmountMilliseconds);
        long $windowSizeMilliseconds = this.getWindowSizeMilliseconds();
        result = result * 59 + (int)($windowSizeMilliseconds >>> 32 ^ $windowSizeMilliseconds);
        String $timeColumn = this.getTimeColumn();
        result = result * 59 + ($timeColumn == null ? 43 : $timeColumn.hashCode());
        TimeUnit $windowSizeUnit = this.getWindowSizeUnit();
        result = result * 59 + ($windowSizeUnit == null ? 43 : ((Object)((Object)$windowSizeUnit)).hashCode());
        TimeUnit $offsetUnit = this.getOffsetUnit();
        result = result * 59 + ($offsetUnit == null ? 43 : ((Object)((Object)$offsetUnit)).hashCode());
        Schema $inputSchema = this.getInputSchema();
        result = result * 59 + ($inputSchema == null ? 43 : ((Object)$inputSchema).hashCode());
        DateTimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        return result;
    }

    public static class Builder {
        private String timeColumn;
        private long windowSize = -1L;
        private TimeUnit windowSizeUnit;
        private long offsetAmount;
        private TimeUnit offsetUnit;
        private boolean addWindowStartTimeColumn = false;
        private boolean addWindowEndTimeColumn = false;
        private boolean excludeEmptyWindows = false;

        public Builder timeColumn(String timeColumn) {
            this.timeColumn = timeColumn;
            return this;
        }

        public Builder windowSize(long windowSize, TimeUnit windowSizeUnit) {
            this.windowSize = windowSize;
            this.windowSizeUnit = windowSizeUnit;
            return this;
        }

        public Builder offset(long offsetAmount, TimeUnit offsetUnit) {
            this.offsetAmount = offsetAmount;
            this.offsetUnit = offsetUnit;
            return this;
        }

        public Builder addWindowStartTimeColumn(boolean addWindowStartTimeColumn) {
            this.addWindowStartTimeColumn = addWindowStartTimeColumn;
            return this;
        }

        public Builder addWindowEndTimeColumn(boolean addWindowEndTimeColumn) {
            this.addWindowEndTimeColumn = addWindowEndTimeColumn;
            return this;
        }

        public Builder excludeEmptyWindows(boolean excludeEmptyWindows) {
            this.excludeEmptyWindows = excludeEmptyWindows;
            return this;
        }

        public TimeWindowFunction build() {
            if (this.timeColumn == null) {
                throw new IllegalStateException("Time column is null (not specified)");
            }
            if (this.windowSize == -1L || this.windowSizeUnit == null) {
                throw new IllegalStateException("Window size/unit not set");
            }
            return new TimeWindowFunction(this);
        }
    }
}

