/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.reduce;

import com.clearspring.analytics.util.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.ReduceOp;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.condition.column.TrivialColumnCondition;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.metadata.FloatMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.ops.AggregableMultiOp;
import org.datavec.api.transform.ops.AggregatorImpls;
import org.datavec.api.transform.ops.DispatchOp;
import org.datavec.api.transform.ops.DispatchWithConditionOp;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.transform.reduce.AggregableColumnReduction;
import org.datavec.api.transform.reduce.AggregableReductionUtils;
import org.datavec.api.transform.reduce.IAssociativeReducer;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"schema", "keyColumnsSet"})
public class Reducer
implements IAssociativeReducer {
    private Schema schema;
    private final List<String> keyColumns;
    private final Set<String> keyColumnsSet;
    private final ReduceOp defaultOp;
    private final Map<String, List<ReduceOp>> opMap;
    private Map<String, ConditionalReduction> conditionalReductions;
    private Map<String, AggregableColumnReduction> customReductions;
    private Set<String> ignoreInvalidInColumns;

    private Reducer(Builder builder) {
        this(builder.keyColumns == null ? null : Arrays.asList(builder.keyColumns), builder.defaultOp, builder.opMap, builder.customReductions, builder.conditionalReductions, builder.ignoreInvalidInColumns);
    }

    public Reducer(@JsonProperty(value="keyColumns") List<String> keyColumns, @JsonProperty(value="defaultOp") ReduceOp defaultOp, @JsonProperty(value="opMap") Map<String, List<ReduceOp>> opMap, @JsonProperty(value="customReductions") Map<String, AggregableColumnReduction> customReductions, @JsonProperty(value="conditionalReductions") Map<String, ConditionalReduction> conditionalReductions, @JsonProperty(value="ignoreInvalidInColumns") Set<String> ignoreInvalidInColumns) {
        this.keyColumns = keyColumns;
        this.keyColumnsSet = keyColumns == null ? null : new HashSet<String>(keyColumns);
        this.defaultOp = defaultOp;
        this.opMap = opMap;
        this.customReductions = customReductions;
        this.conditionalReductions = conditionalReductions;
        this.ignoreInvalidInColumns = ignoreInvalidInColumns;
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.schema = schema;
        for (ConditionalReduction cr : this.conditionalReductions.values()) {
            cr.getCondition().setInputSchema(schema);
        }
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    @Override
    public List<String> getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public Schema transform(Schema schema) {
        int nCols = schema.numColumns();
        List<String> colNames = schema.getColumnNames();
        List<ColumnMetaData> meta = schema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(nCols);
        for (int i = 0; i < nCols; ++i) {
            List<ReduceOp> lop;
            Serializable reduction;
            String name = colNames.get(i);
            ColumnMetaData inMeta = meta.get(i);
            if (this.keyColumnsSet != null && this.keyColumnsSet.contains(name)) {
                newMeta.add(inMeta);
                continue;
            }
            if (this.customReductions != null && this.customReductions.containsKey(name)) {
                reduction = this.customReductions.get(name);
                List<String> outName = reduction.getColumnsOutputName(name);
                List<ColumnMetaData> outMeta = reduction.getColumnOutputMetaData(outName, inMeta);
                newMeta.addAll(outMeta);
                continue;
            }
            if (this.conditionalReductions != null && this.conditionalReductions.containsKey(name)) {
                reduction = this.conditionalReductions.get(name);
                List<String> outNames = ((ConditionalReduction)reduction).getOutputNames();
                List<ReduceOp> reductions = ((ConditionalReduction)reduction).getReductions();
                for (int j = 0; j < ((ConditionalReduction)reduction).getReductions().size(); ++j) {
                    ReduceOp red = reductions.get(j);
                    String outName = outNames.get(j);
                    ColumnMetaData m = Reducer.getMetaForColumn(red, name, inMeta);
                    m.setName(outName);
                    newMeta.add(m);
                }
                continue;
            }
            List<ReduceOp> list = lop = this.opMap.containsKey(name) ? this.opMap.get(name) : Collections.singletonList(this.defaultOp);
            if (lop == null) continue;
            for (ReduceOp op : lop) {
                newMeta.add(Reducer.getMetaForColumn(op, name, inMeta));
            }
        }
        return schema.newSchema(newMeta);
    }

    private static String getOutNameForColumn(ReduceOp op, String name) {
        return op.name().toLowerCase() + "(" + name + ")";
    }

    private static ColumnMetaData getMetaForColumn(ReduceOp op, String name, ColumnMetaData inMeta) {
        inMeta = inMeta.clone();
        switch (op) {
            case Min: 
            case Max: 
            case Range: 
            case TakeFirst: 
            case TakeLast: {
                inMeta.setName(Reducer.getOutNameForColumn(op, name));
                return inMeta;
            }
            case Prod: 
            case Sum: {
                String outName = Reducer.getOutNameForColumn(op, name);
                ColumnMetaData outMeta = inMeta instanceof IntegerMetaData ? new IntegerMetaData(outName) : (inMeta instanceof LongMetaData ? new LongMetaData(outName) : (inMeta instanceof FloatMetaData ? new FloatMetaData(outName) : (inMeta instanceof DoubleMetaData ? new DoubleMetaData(outName) : inMeta)));
                outMeta.setName(outName);
                return outMeta;
            }
            case Mean: 
            case Stdev: 
            case Variance: 
            case PopulationVariance: 
            case UncorrectedStdDev: {
                return new DoubleMetaData(Reducer.getOutNameForColumn(op, name));
            }
            case Append: 
            case Prepend: {
                return new StringMetaData(Reducer.getOutNameForColumn(op, name));
            }
            case Count: 
            case CountUnique: {
                return new LongMetaData(Reducer.getOutNameForColumn(op, name), 0L, null);
            }
        }
        throw new UnsupportedOperationException("Unknown or not implemented op: " + op);
    }

    @Override
    public IAggregableReduceOp<List<Writable>, List<Writable>> aggregableReducer() {
        if (this.schema == null) {
            throw new IllegalStateException("Error: Schema has not been set");
        }
        int nCols = this.schema.numColumns();
        List<String> colNames = this.schema.getColumnNames();
        ArrayList ops = new ArrayList(nCols);
        boolean conditionalActive = this.conditionalReductions != null && !this.conditionalReductions.isEmpty();
        ArrayList<Condition> conditions = new ArrayList<Condition>(nCols);
        for (int i = 0; i < nCols; ++i) {
            List<ReduceOp> lop;
            String colName = colNames.get(i);
            if (this.keyColumnsSet != null && this.keyColumnsSet.contains(colName)) {
                AggregatorImpls.AggregableFirst first = new AggregatorImpls.AggregableFirst();
                ops.add(new AggregableMultiOp(Collections.singletonList(first)));
                if (!conditionalActive) continue;
                conditions.add(new TrivialColumnCondition(colName));
                continue;
            }
            if (this.customReductions != null && this.customReductions.containsKey(colName)) {
                AggregableColumnReduction reduction = this.customReductions.get(colName);
                ops.add(reduction.reduceOp());
                if (!conditionalActive) continue;
                conditions.add(new TrivialColumnCondition(colName));
                continue;
            }
            if (conditionalActive) {
                if (this.conditionalReductions.containsKey(colName)) {
                    conditions.add(this.conditionalReductions.get(colName).getCondition());
                } else {
                    conditions.add(new TrivialColumnCondition(colName));
                }
            }
            ColumnType type = this.schema.getType(i);
            boolean conditionalOp = conditionalActive && this.conditionalReductions.containsKey(colName);
            List<ReduceOp> list = lop = conditionalOp ? this.conditionalReductions.get(colName).getReductions() : this.opMap.get(colName);
            if (lop == null || lop.isEmpty()) {
                lop = Collections.singletonList(this.defaultOp);
            }
            ops.add(AggregableReductionUtils.reduceColumn(lop, type, this.ignoreInvalidInColumns.contains(colName), this.schema.getMetaData(i)));
        }
        if (conditionalActive) {
            return new DispatchWithConditionOp<Writable>(ops, conditions);
        }
        return new DispatchOp<Writable, Writable>(ops);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Reducer(");
        if (this.keyColumns != null) {
            sb.append("keyColumns=").append(this.keyColumns).append(",");
        }
        sb.append("defaultOp=").append((Object)this.defaultOp);
        if (this.opMap != null) {
            sb.append(",opMap=").append(this.opMap);
        }
        if (this.customReductions != null) {
            sb.append(",customReductions=").append(this.customReductions);
        }
        if (this.conditionalReductions != null) {
            sb.append(",conditionalReductions=").append(this.conditionalReductions);
        }
        if (this.ignoreInvalidInColumns != null) {
            sb.append(",ignoreInvalidInColumns=").append(this.ignoreInvalidInColumns);
        }
        sb.append(")");
        return sb.toString();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Set<String> getKeyColumnsSet() {
        return this.keyColumnsSet;
    }

    public ReduceOp getDefaultOp() {
        return this.defaultOp;
    }

    public Map<String, List<ReduceOp>> getOpMap() {
        return this.opMap;
    }

    public Map<String, ConditionalReduction> getConditionalReductions() {
        return this.conditionalReductions;
    }

    public Map<String, AggregableColumnReduction> getCustomReductions() {
        return this.customReductions;
    }

    public Set<String> getIgnoreInvalidInColumns() {
        return this.ignoreInvalidInColumns;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setConditionalReductions(Map<String, ConditionalReduction> conditionalReductions) {
        this.conditionalReductions = conditionalReductions;
    }

    public void setCustomReductions(Map<String, AggregableColumnReduction> customReductions) {
        this.customReductions = customReductions;
    }

    public void setIgnoreInvalidInColumns(Set<String> ignoreInvalidInColumns) {
        this.ignoreInvalidInColumns = ignoreInvalidInColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reducer)) {
            return false;
        }
        Reducer other = (Reducer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$keyColumns = this.getKeyColumns();
        List<String> other$keyColumns = other.getKeyColumns();
        if (this$keyColumns == null ? other$keyColumns != null : !((Object)this$keyColumns).equals(other$keyColumns)) {
            return false;
        }
        ReduceOp this$defaultOp = this.getDefaultOp();
        ReduceOp other$defaultOp = other.getDefaultOp();
        if (this$defaultOp == null ? other$defaultOp != null : !((Object)((Object)this$defaultOp)).equals((Object)other$defaultOp)) {
            return false;
        }
        Map<String, List<ReduceOp>> this$opMap = this.getOpMap();
        Map<String, List<ReduceOp>> other$opMap = other.getOpMap();
        if (this$opMap == null ? other$opMap != null : !((Object)this$opMap).equals(other$opMap)) {
            return false;
        }
        Map<String, ConditionalReduction> this$conditionalReductions = this.getConditionalReductions();
        Map<String, ConditionalReduction> other$conditionalReductions = other.getConditionalReductions();
        if (this$conditionalReductions == null ? other$conditionalReductions != null : !((Object)this$conditionalReductions).equals(other$conditionalReductions)) {
            return false;
        }
        Map<String, AggregableColumnReduction> this$customReductions = this.getCustomReductions();
        Map<String, AggregableColumnReduction> other$customReductions = other.getCustomReductions();
        if (this$customReductions == null ? other$customReductions != null : !((Object)this$customReductions).equals(other$customReductions)) {
            return false;
        }
        Set<String> this$ignoreInvalidInColumns = this.getIgnoreInvalidInColumns();
        Set<String> other$ignoreInvalidInColumns = other.getIgnoreInvalidInColumns();
        return !(this$ignoreInvalidInColumns == null ? other$ignoreInvalidInColumns != null : !((Object)this$ignoreInvalidInColumns).equals(other$ignoreInvalidInColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Reducer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $keyColumns = this.getKeyColumns();
        result = result * 59 + ($keyColumns == null ? 43 : ((Object)$keyColumns).hashCode());
        ReduceOp $defaultOp = this.getDefaultOp();
        result = result * 59 + ($defaultOp == null ? 43 : ((Object)((Object)$defaultOp)).hashCode());
        Map<String, List<ReduceOp>> $opMap = this.getOpMap();
        result = result * 59 + ($opMap == null ? 43 : ((Object)$opMap).hashCode());
        Map<String, ConditionalReduction> $conditionalReductions = this.getConditionalReductions();
        result = result * 59 + ($conditionalReductions == null ? 43 : ((Object)$conditionalReductions).hashCode());
        Map<String, AggregableColumnReduction> $customReductions = this.getCustomReductions();
        result = result * 59 + ($customReductions == null ? 43 : ((Object)$customReductions).hashCode());
        Set<String> $ignoreInvalidInColumns = this.getIgnoreInvalidInColumns();
        result = result * 59 + ($ignoreInvalidInColumns == null ? 43 : ((Object)$ignoreInvalidInColumns).hashCode());
        return result;
    }

    public static class ConditionalReduction
    implements Serializable {
        private final String columnName;
        private final List<String> outputNames;
        private final List<ReduceOp> reductions;
        private final Condition condition;

        public ConditionalReduction(String columnName, List<String> outputNames, List<ReduceOp> reductions, Condition condition) {
            this.columnName = columnName;
            this.outputNames = outputNames;
            this.reductions = reductions;
            this.condition = condition;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public List<String> getOutputNames() {
            return this.outputNames;
        }

        public List<ReduceOp> getReductions() {
            return this.reductions;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionalReduction)) {
                return false;
            }
            ConditionalReduction other = (ConditionalReduction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            List<String> this$outputNames = this.getOutputNames();
            List<String> other$outputNames = other.getOutputNames();
            if (this$outputNames == null ? other$outputNames != null : !((Object)this$outputNames).equals(other$outputNames)) {
                return false;
            }
            List<ReduceOp> this$reductions = this.getReductions();
            List<ReduceOp> other$reductions = other.getReductions();
            if (this$reductions == null ? other$reductions != null : !((Object)this$reductions).equals(other$reductions)) {
                return false;
            }
            Condition this$condition = this.getCondition();
            Condition other$condition = other.getCondition();
            return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConditionalReduction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            List<String> $outputNames = this.getOutputNames();
            result = result * 59 + ($outputNames == null ? 43 : ((Object)$outputNames).hashCode());
            List<ReduceOp> $reductions = this.getReductions();
            result = result * 59 + ($reductions == null ? 43 : ((Object)$reductions).hashCode());
            Condition $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
            return result;
        }

        public String toString() {
            return "Reducer.ConditionalReduction(columnName=" + this.getColumnName() + ", outputNames=" + this.getOutputNames() + ", reductions=" + this.getReductions() + ", condition=" + this.getCondition() + ")";
        }
    }

    public static class Builder {
        private ReduceOp defaultOp;
        private Map<String, List<ReduceOp>> opMap = new HashMap<String, List<ReduceOp>>();
        private Map<String, AggregableColumnReduction> customReductions = new HashMap<String, AggregableColumnReduction>();
        private Map<String, ConditionalReduction> conditionalReductions = new HashMap<String, ConditionalReduction>();
        private Set<String> ignoreInvalidInColumns = new HashSet<String>();
        private String[] keyColumns;

        public Builder(ReduceOp defaultOp) {
            this.defaultOp = defaultOp;
        }

        public Builder keyColumns(String ... keyColumns) {
            this.keyColumns = keyColumns;
            return this;
        }

        private Builder add(ReduceOp op, String[] cols) {
            for (String s : cols) {
                ArrayList<ReduceOp> ops = new ArrayList<ReduceOp>();
                if (this.opMap.containsKey(s)) {
                    ops.addAll((Collection)this.opMap.get(s));
                }
                ops.add(op);
                this.opMap.put(s, ops);
            }
            return this;
        }

        private Builder addAll(List<ReduceOp> ops, String[] cols) {
            for (String s : cols) {
                ArrayList<ReduceOp> theseOps = new ArrayList<ReduceOp>();
                if (this.opMap.containsKey(s)) {
                    theseOps.addAll((Collection)this.opMap.get(s));
                }
                theseOps.addAll(ops);
                this.opMap.put(s, theseOps);
            }
            return this;
        }

        public Builder multipleOpColmumns(List<ReduceOp> ops, String ... columns) {
            return this.addAll(ops, columns);
        }

        public Builder minColumns(String ... columns) {
            return this.add(ReduceOp.Min, columns);
        }

        public Builder maxColumn(String ... columns) {
            return this.add(ReduceOp.Max, columns);
        }

        public Builder sumColumns(String ... columns) {
            return this.add(ReduceOp.Sum, columns);
        }

        public Builder prodColumns(String ... columns) {
            return this.add(ReduceOp.Prod, columns);
        }

        public Builder meanColumns(String ... columns) {
            return this.add(ReduceOp.Mean, columns);
        }

        public Builder stdevColumns(String ... columns) {
            return this.add(ReduceOp.Stdev, columns);
        }

        public Builder uncorrectedStdevColumns(String ... columns) {
            return this.add(ReduceOp.Stdev, columns);
        }

        public Builder variance(String ... columns) {
            return this.add(ReduceOp.Variance, columns);
        }

        public Builder populationVariance(String ... columns) {
            return this.add(ReduceOp.PopulationVariance, columns);
        }

        public Builder countColumns(String ... columns) {
            return this.add(ReduceOp.Count, columns);
        }

        public Builder rangeColumns(String ... columns) {
            return this.add(ReduceOp.Range, columns);
        }

        public Builder countUniqueColumns(String ... columns) {
            return this.add(ReduceOp.CountUnique, columns);
        }

        public Builder takeFirstColumns(String ... columns) {
            return this.add(ReduceOp.TakeFirst, columns);
        }

        public Builder takeLastColumns(String ... columns) {
            return this.add(ReduceOp.TakeLast, columns);
        }

        public Builder appendColumns(String ... columns) {
            return this.add(ReduceOp.Append, columns);
        }

        public Builder prependColumns(String ... columns) {
            return this.add(ReduceOp.Prepend, columns);
        }

        public Builder customReduction(String column, AggregableColumnReduction columnReduction) {
            this.customReductions.put(column, columnReduction);
            return this;
        }

        public Builder conditionalReduction(String column, List<String> outputNames, List<ReduceOp> reductions, Condition condition) {
            Preconditions.checkArgument((outputNames.size() == reductions.size() ? 1 : 0) != 0, (String)"Conditional reductions should provide names for every column", (Object[])new Object[0]);
            this.conditionalReductions.put(column, new ConditionalReduction(column, outputNames, reductions, condition));
            return this;
        }

        public Builder conditionalReduction(String column, String outputName, ReduceOp reduction, Condition condition) {
            this.conditionalReductions.put(column, new ConditionalReduction(column, Collections.singletonList(outputName), Collections.singletonList(reduction), condition));
            return this;
        }

        public Builder setIgnoreInvalid(String ... columns) {
            Collections.addAll(this.ignoreInvalidInColumns, columns);
            return this;
        }

        public Reducer build() {
            return new Reducer(this);
        }
    }
}

