/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.BaseColumnMetaData;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"stateNamesSet"})
public class CategoricalMetaData
extends BaseColumnMetaData {
    private final List<String> stateNames;
    private final Set<String> stateNamesSet;

    public CategoricalMetaData(String name, String ... stateNames) {
        this(name, Arrays.asList(stateNames));
    }

    public CategoricalMetaData(@JsonProperty(value="name") String name, @JsonProperty(value="stateNames") List<String> stateNames) {
        super(name);
        this.stateNames = stateNames;
        this.stateNamesSet = new HashSet<String>(stateNames);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Categorical;
    }

    @Override
    public boolean isValid(Writable writable) {
        return this.stateNamesSet.contains(writable.toString());
    }

    @Override
    public boolean isValid(Object input) {
        return this.stateNamesSet.contains(input.toString());
    }

    @Override
    public CategoricalMetaData clone() {
        return new CategoricalMetaData(this.name, this.stateNames);
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CategoricalMetaData(name=\"").append(this.name).append("\",stateNames=[");
        boolean first = true;
        for (String s : this.stateNamesSet) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"").append(s).append("\"");
            first = false;
        }
        sb.append("])");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoricalMetaData)) {
            return false;
        }
        CategoricalMetaData other = (CategoricalMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$stateNames = this.getStateNames();
        List<String> other$stateNames = other.getStateNames();
        if (this$stateNames == null ? other$stateNames != null : !((Object)this$stateNames).equals(other$stateNames)) {
            return false;
        }
        Set<String> this$stateNamesSet = this.getStateNamesSet();
        Set<String> other$stateNamesSet = other.getStateNamesSet();
        return !(this$stateNamesSet == null ? other$stateNamesSet != null : !((Object)this$stateNamesSet).equals(other$stateNamesSet));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CategoricalMetaData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $stateNames = this.getStateNames();
        result = result * 59 + ($stateNames == null ? 43 : ((Object)$stateNames).hashCode());
        Set<String> $stateNamesSet = this.getStateNamesSet();
        result = result * 59 + ($stateNamesSet == null ? 43 : ((Object)$stateNamesSet).hashCode());
        return result;
    }

    public Set<String> getStateNamesSet() {
        return this.stateNamesSet;
    }
}

