/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.quality.integer;

import java.io.Serializable;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.quality.columns.IntegerQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.common.function.BiFunction;

public class IntegerQualityAddFunction
implements BiFunction<IntegerQuality, Writable, IntegerQuality>,
Serializable {
    private final IntegerMetaData meta;

    public IntegerQuality apply(IntegerQuality v1, Writable writable) {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        long nonInteger = v1.getCountNonInteger();
        if (this.meta.isValid(writable)) {
            ++valid;
        } else if (writable instanceof NullWritable || writable instanceof Text && (writable.toString() == null || writable.toString().isEmpty())) {
            ++countMissing;
        } else {
            ++invalid;
        }
        String str = writable.toString();
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            ++nonInteger;
        }
        return new IntegerQuality(valid, invalid, countMissing, countTotal, nonInteger);
    }

    public IntegerQualityAddFunction(IntegerMetaData meta) {
        this.meta = meta;
    }
}

