/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.counter;

import java.io.Serializable;

public class StatCounter
implements Serializable {
    private long count = 0L;
    private double runningMean;
    private double runningM2;
    private double max = -1.7976931348623157E308;
    private double min = Double.MAX_VALUE;

    public double getMean() {
        return this.runningMean;
    }

    public double getSum() {
        return this.runningMean * (double)this.count;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public long getCount() {
        return this.count;
    }

    public double getVariance(boolean population) {
        long divisor;
        long l = divisor = population ? this.count : this.count - 1L;
        if (population && this.count == 0L || !population && this.count == 1L) {
            return Double.NaN;
        }
        return this.runningM2 / (double)divisor;
    }

    public double getStddev(boolean population) {
        return Math.sqrt(this.getVariance(population));
    }

    public void add(double x) {
        double d = x - this.runningMean;
        ++this.count;
        this.runningMean += d / (double)this.count;
        this.runningM2 += d * (x - this.runningMean);
        this.max = Math.max(this.max, x);
        this.min = Math.min(this.min, x);
    }

    public StatCounter merge(StatCounter o) {
        if (o == null || o.count == 0L) {
            return this;
        }
        if (o == this) {
            return this.merge(o.clone());
        }
        if (this.count == 0L) {
            this.count = o.count;
            this.runningMean = o.runningMean;
            this.runningMean = o.runningM2;
            this.max = o.max;
            this.min = o.min;
        } else {
            this.min = Math.min(this.min, o.min);
            this.max = Math.max(this.max, o.max);
            double d = o.runningMean - this.runningMean;
            this.runningMean = o.count * 10L < this.count ? (this.runningMean += d * (double)o.count / (double)(this.count + o.count)) : (this.count * 10L < o.count ? o.runningMean - d * (double)this.count / (double)(this.count + o.count) : (this.runningMean * (double)this.count + o.runningMean * (double)o.count) / (double)(this.count + o.count));
            this.runningM2 += o.runningM2 + d * d * (double)this.count * (double)o.count / (double)(this.count + o.count);
            this.count += o.count;
        }
        return this;
    }

    public StatCounter clone() {
        StatCounter ret = new StatCounter();
        ret.count = this.count;
        ret.runningMean = this.runningMean;
        ret.runningM2 = this.runningM2;
        ret.max = this.max;
        ret.min = this.min;
        return ret;
    }

    public String toString() {
        return "StatCounter(count=" + this.count + ",mean=" + this.runningMean + ",stdev=" + this.getStddev(false) + ",min=" + this.min + ",max=" + this.max + ")";
    }
}

