/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.columns;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.NumericalColumnAnalysis;

public class DoubleAnalysis
extends NumericalColumnAnalysis {
    private double min;
    private double max;
    private long countNaN;

    private DoubleAnalysis(Builder builder) {
        super(builder);
        this.min = builder.min;
        this.max = builder.max;
        this.countNaN = builder.countNaN;
    }

    @Override
    public String toString() {
        return "DoubleAnalysis(min=" + this.min + ",max=" + this.max + "," + super.toString() + ")";
    }

    @Override
    public double getMinDouble() {
        return this.min;
    }

    @Override
    public double getMaxDouble() {
        return this.max;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Double;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleAnalysis)) {
            return false;
        }
        DoubleAnalysis other = (DoubleAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getMin(), other.getMin()) != 0) {
            return false;
        }
        if (Double.compare(this.getMax(), other.getMax()) != 0) {
            return false;
        }
        return this.getCountNaN() == other.getCountNaN();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DoubleAnalysis;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $min = Double.doubleToLongBits(this.getMin());
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $max = Double.doubleToLongBits(this.getMax());
        result = result * 59 + (int)($max >>> 32 ^ $max);
        long $countNaN = this.getCountNaN();
        result = result * 59 + (int)($countNaN >>> 32 ^ $countNaN);
        return result;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public long getCountNaN() {
        return this.countNaN;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setCountNaN(long countNaN) {
        this.countNaN = countNaN;
    }

    public DoubleAnalysis() {
    }

    public static class Builder
    extends NumericalColumnAnalysis.Builder<Builder> {
        private double min;
        private double max;
        private long countNaN;

        public Builder min(double min) {
            this.min = min;
            return this;
        }

        public Builder max(double max) {
            this.max = max;
            return this;
        }

        public Builder countNaN(long countNaN) {
            this.countNaN = countNaN;
            return this;
        }

        public DoubleAnalysis build() {
            return new DoubleAnalysis(this);
        }
    }
}

