/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.impl;

import java.util.List;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.writable.Writable;

public class SequenceRecord
implements org.datavec.api.records.SequenceRecord {
    private List<List<Writable>> sequenceRecord;
    private RecordMetaData metaData;

    @Override
    public int getSequenceLength() {
        if (this.sequenceRecord == null) {
            return 0;
        }
        return this.sequenceRecord.size();
    }

    @Override
    public List<Writable> getTimeStep(int timeStep) {
        if (timeStep < 0 || timeStep > this.sequenceRecord.size()) {
            throw new IllegalArgumentException("Invalid input: " + this.sequenceRecord.size() + " time steps available; cannot get " + timeStep);
        }
        return this.sequenceRecord.get(timeStep);
    }

    public SequenceRecord(List<List<Writable>> sequenceRecord, RecordMetaData metaData) {
        this.sequenceRecord = sequenceRecord;
        this.metaData = metaData;
    }

    @Override
    public List<List<Writable>> getSequenceRecord() {
        return this.sequenceRecord;
    }

    @Override
    public RecordMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void setSequenceRecord(List<List<Writable>> sequenceRecord) {
        this.sequenceRecord = sequenceRecord;
    }

    @Override
    public void setMetaData(RecordMetaData metaData) {
        this.metaData = metaData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceRecord)) {
            return false;
        }
        SequenceRecord other = (SequenceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<List<Writable>> this$sequenceRecord = this.getSequenceRecord();
        List<List<Writable>> other$sequenceRecord = other.getSequenceRecord();
        if (this$sequenceRecord == null ? other$sequenceRecord != null : !((Object)this$sequenceRecord).equals(other$sequenceRecord)) {
            return false;
        }
        RecordMetaData this$metaData = this.getMetaData();
        RecordMetaData other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<Writable>> $sequenceRecord = this.getSequenceRecord();
        result = result * 59 + ($sequenceRecord == null ? 43 : ((Object)$sequenceRecord).hashCode());
        RecordMetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        return result;
    }

    public String toString() {
        return "SequenceRecord(sequenceRecord=" + this.getSequenceRecord() + ", metaData=" + this.getMetaData() + ")";
    }
}

