/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable;

import org.datavec.api.writable.BooleanWritable;
import org.datavec.api.writable.ByteWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public enum WritableType {
    Boolean,
    Byte,
    Double,
    Float,
    Int,
    Long,
    Null,
    Text,
    NDArray,
    Image;


    public boolean isCoreWritable() {
        switch (this) {
            case Image: {
                return false;
            }
        }
        return true;
    }

    public short typeIdx() {
        return (short)this.ordinal();
    }

    public Class<? extends Writable> getWritableClass() {
        switch (this) {
            case Boolean: {
                return BooleanWritable.class;
            }
            case Byte: {
                return ByteWritable.class;
            }
            case Double: {
                return DoubleWritable.class;
            }
            case Float: {
                return FloatWritable.class;
            }
            case Int: {
                return IntWritable.class;
            }
            case Long: {
                return LongWritable.class;
            }
            case Null: {
                return NullWritable.class;
            }
            case Text: {
                return Text.class;
            }
            case NDArray: {
                return NDArrayWritable.class;
            }
        }
        return null;
    }
}

