/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util;

import java.util.concurrent.TimeUnit;

public class TransformUtils {
    public static String timeUnitToString(long time, TimeUnit unit) {
        String str = String.valueOf(time);
        switch (unit) {
            case MILLISECONDS: {
                str = str + "Millisecond";
                break;
            }
            case SECONDS: {
                str = str + "Second";
                break;
            }
            case MINUTES: {
                str = str + "Minute";
                break;
            }
            case HOURS: {
                str = str + "Hour";
                break;
            }
            case DAYS: {
                str = str + "Day";
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (time == 1L) {
            return str;
        }
        return str + "s";
    }

    public static TimeUnit stringToTimeUnit(String str) {
        switch (str.toLowerCase()) {
            case "ms": 
            case "millisecond": 
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": 
            case "sec": 
            case "second": 
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "min": 
            case "minute": 
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "h": 
            case "hour": 
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "day": 
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new RuntimeException("Unknown time unit: \"" + str + "\"");
    }
}

