/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.datavec.api.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResource {
    private String resourceName;
    private static Logger log = LoggerFactory.getLogger(ClassPathResource.class);

    public ClassPathResource(String resourceName) {
        if (resourceName == null) {
            throw new IllegalStateException("Resource name can't be null");
        }
        this.resourceName = resourceName;
    }

    private URL getUrl() {
        URL url;
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loader == null) {
            loader = ClassPathResource.class.getClassLoader();
        }
        if ((url = loader.getResource(this.resourceName)) == null) {
            if (this.resourceName.startsWith("/") ? (url = loader.getResource(this.resourceName.replaceFirst("[\\\\/]", ""))) != null : (url = loader.getResource("/" + this.resourceName)) != null) {
                return url;
            }
            throw new IllegalStateException("Resource '" + this.resourceName + "' cannot be found.");
        }
        return url;
    }

    public File getFile() throws FileNotFoundException {
        return this.getFile(null);
    }

    public File getFile(String suffix) throws FileNotFoundException {
        URL url = this.getUrl();
        if (this.isJarURL(url)) {
            try {
                GetStreamFromZip getStreamFromZip = new GetStreamFromZip(url, this.resourceName).invoke();
                ZipEntry entry = getStreamFromZip.getEntry();
                InputStream stream = getStreamFromZip.getStream();
                ZipFile zipFile = getStreamFromZip.getZipFile();
                url = getStreamFromZip.getUrl();
                if (entry.isDirectory() || stream == null) {
                    zipFile.close();
                    File dir = new File(System.getProperty("java.io.tmpdir"), "datavec_temp" + System.nanoTime() + (suffix != null ? suffix : "dir"));
                    if (dir.mkdir()) {
                        dir.deleteOnExit();
                    }
                    ArchiveUtils.unzipFileTo(url.getFile(), dir.getAbsolutePath());
                    return new File(dir, this.resourceName);
                }
                long size = entry.getSize();
                File file = File.createTempFile("datavec_temp", suffix != null ? suffix : "file");
                file.deleteOnExit();
                FileOutputStream outputStream = new FileOutputStream(file);
                byte[] array = new byte[1024];
                int rd = 0;
                long bytesRead = 0L;
                do {
                    rd = stream.read(array);
                    outputStream.write(array, 0, rd);
                } while ((bytesRead += (long)rd) < size);
                outputStream.flush();
                outputStream.close();
                stream.close();
                zipFile.close();
                return file;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            URI uri = new URI(url.toString().replaceAll(" ", "%20"));
            return new File(uri.getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            return new File(url.getFile());
        }
    }

    private boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol) || "code-source".equals(protocol) && url.getPath().contains("!/");
    }

    private URL extractActualUrl(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException var5) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                return new URL("file:" + jarFile);
            }
        }
        return jarUrl;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        URL url = this.getUrl();
        if (this.isJarURL(url)) {
            try {
                GetStreamFromZip getStreamFromZip = new GetStreamFromZip(url, this.resourceName).invoke();
                InputStream stream = getStreamFromZip.getStream();
                return stream;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        File srcFile = this.getFile();
        return new FileInputStream(srcFile);
    }

    private class GetStreamFromZip {
        private URL url;
        private ZipFile zipFile;
        private ZipEntry entry;
        private InputStream stream;
        private String resourceName;

        public GetStreamFromZip(URL url, String resourceName) {
            this.url = url;
            this.resourceName = resourceName;
        }

        public URL getUrl() {
            return this.url;
        }

        public ZipFile getZipFile() {
            return this.zipFile;
        }

        public ZipEntry getEntry() {
            return this.entry;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public GetStreamFromZip invoke() throws IOException {
            this.url = ClassPathResource.this.extractActualUrl(this.url);
            this.zipFile = new ZipFile(this.url.getFile());
            this.entry = this.zipFile.getEntry(this.resourceName);
            if (this.entry == null) {
                if (this.resourceName.startsWith("/")) {
                    this.entry = this.zipFile.getEntry(this.resourceName.replaceFirst("/", ""));
                    if (this.entry == null) {
                        throw new FileNotFoundException("Resource " + this.resourceName + " not found");
                    }
                } else {
                    throw new FileNotFoundException("Resource " + this.resourceName + " not found");
                }
            }
            this.stream = this.zipFile.getInputStream(this.entry);
            return this;
        }
    }
}

