/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ui.components;

import java.util.Arrays;
import org.datavec.api.transform.ui.components.RenderableComponent;

public class RenderableComponentTable
extends RenderableComponent {
    public static final String COMPONENT_TYPE = "simpletable";
    private String title;
    private String[] header;
    private String[][] table;
    private int padLeftPx = 0;
    private int padRightPx = 0;
    private int padTopPx = 0;
    private int padBottomPx = 0;
    private int border = 0;
    private double[] colWidthsPercent = null;
    private String backgroundColor;
    private String headerColor;

    public RenderableComponentTable() {
        super(COMPONENT_TYPE);
    }

    public RenderableComponentTable(Builder builder) {
        super(COMPONENT_TYPE);
        this.title = builder.title;
        this.header = builder.header;
        this.table = builder.table;
        this.padLeftPx = builder.padLeftPx;
        this.padRightPx = builder.padRightPx;
        this.padTopPx = builder.padTopPx;
        this.padBottomPx = builder.padBottomPx;
        this.border = builder.border;
        this.colWidthsPercent = builder.colWidthsPercent;
        this.backgroundColor = builder.backgroundColor;
        this.headerColor = builder.headerColor;
    }

    public RenderableComponentTable(String[] header, String[][] table) {
        this(null, header, table);
    }

    public RenderableComponentTable(String title, String[] header, String[][] table) {
        super(COMPONENT_TYPE);
        this.title = title;
        this.header = header;
        this.table = table;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderableComponentTable)) {
            return false;
        }
        RenderableComponentTable other = (RenderableComponentTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHeader(), other.getHeader())) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getTable(), (Object[])other.getTable())) {
            return false;
        }
        if (this.getPadLeftPx() != other.getPadLeftPx()) {
            return false;
        }
        if (this.getPadRightPx() != other.getPadRightPx()) {
            return false;
        }
        if (this.getPadTopPx() != other.getPadTopPx()) {
            return false;
        }
        if (this.getPadBottomPx() != other.getPadBottomPx()) {
            return false;
        }
        if (this.getBorder() != other.getBorder()) {
            return false;
        }
        if (!Arrays.equals(this.getColWidthsPercent(), other.getColWidthsPercent())) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor)) {
            return false;
        }
        String this$headerColor = this.getHeaderColor();
        String other$headerColor = other.getHeaderColor();
        return !(this$headerColor == null ? other$headerColor != null : !this$headerColor.equals(other$headerColor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RenderableComponentTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHeader());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getTable());
        result = result * 59 + this.getPadLeftPx();
        result = result * 59 + this.getPadRightPx();
        result = result * 59 + this.getPadTopPx();
        result = result * 59 + this.getPadBottomPx();
        result = result * 59 + this.getBorder();
        result = result * 59 + Arrays.hashCode(this.getColWidthsPercent());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        String $headerColor = this.getHeaderColor();
        result = result * 59 + ($headerColor == null ? 43 : $headerColor.hashCode());
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getHeader() {
        return this.header;
    }

    public String[][] getTable() {
        return this.table;
    }

    public int getPadLeftPx() {
        return this.padLeftPx;
    }

    public int getPadRightPx() {
        return this.padRightPx;
    }

    public int getPadTopPx() {
        return this.padTopPx;
    }

    public int getPadBottomPx() {
        return this.padBottomPx;
    }

    public int getBorder() {
        return this.border;
    }

    public double[] getColWidthsPercent() {
        return this.colWidthsPercent;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getHeaderColor() {
        return this.headerColor;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setHeader(String[] header) {
        this.header = header;
    }

    public void setTable(String[][] table) {
        this.table = table;
    }

    public void setPadLeftPx(int padLeftPx) {
        this.padLeftPx = padLeftPx;
    }

    public void setPadRightPx(int padRightPx) {
        this.padRightPx = padRightPx;
    }

    public void setPadTopPx(int padTopPx) {
        this.padTopPx = padTopPx;
    }

    public void setPadBottomPx(int padBottomPx) {
        this.padBottomPx = padBottomPx;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public void setColWidthsPercent(double[] colWidthsPercent) {
        this.colWidthsPercent = colWidthsPercent;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setHeaderColor(String headerColor) {
        this.headerColor = headerColor;
    }

    @Override
    public String toString() {
        return "RenderableComponentTable(title=" + this.getTitle() + ", header=" + Arrays.deepToString(this.getHeader()) + ", table=" + Arrays.deepToString((Object[])this.getTable()) + ", padLeftPx=" + this.getPadLeftPx() + ", padRightPx=" + this.getPadRightPx() + ", padTopPx=" + this.getPadTopPx() + ", padBottomPx=" + this.getPadBottomPx() + ", border=" + this.getBorder() + ", colWidthsPercent=" + Arrays.toString(this.getColWidthsPercent()) + ", backgroundColor=" + this.getBackgroundColor() + ", headerColor=" + this.getHeaderColor() + ")";
    }

    public static class Builder {
        private String title;
        private String[] header;
        private String[][] table;
        private int padLeftPx = 0;
        private int padRightPx = 0;
        private int padTopPx = 0;
        private int padBottomPx = 0;
        private int border = 0;
        private double[] colWidthsPercent;
        private String backgroundColor;
        private String headerColor;

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder header(String ... header) {
            this.header = header;
            return this;
        }

        public Builder table(String[][] table) {
            this.table = table;
            return this;
        }

        public Builder border(int border) {
            this.border = border;
            return this;
        }

        public Builder padLeftPx(int padLeftPx) {
            this.padLeftPx = padLeftPx;
            return this;
        }

        public Builder padRightPx(int padRightPx) {
            this.padRightPx = padRightPx;
            return this;
        }

        public Builder padTopPx(int padTopPx) {
            this.padTopPx = padTopPx;
            return this;
        }

        public Builder padBottomPx(int padBottomPx) {
            this.padBottomPx = padBottomPx;
            return this;
        }

        public Builder paddingPx(int paddingPx) {
            this.padLeftPx(paddingPx);
            this.padRightPx(paddingPx);
            this.padTopPx(paddingPx);
            this.padBottomPx(paddingPx);
            return this;
        }

        public Builder paddingPx(int left, int right, int top, int bottom) {
            this.padLeftPx(left);
            this.padRightPx(right);
            this.padTopPx(top);
            this.padBottomPx(bottom);
            return this;
        }

        public Builder colWidthsPercent(double ... colWidthsPercent) {
            this.colWidthsPercent = colWidthsPercent;
            return this;
        }

        public Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder headerColor(String headerColor) {
            this.headerColor = headerColor;
            return this;
        }

        public RenderableComponentTable build() {
            return new RenderableComponentTable(this);
        }
    }
}

