/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class CategoricalColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final String value;
    private final Set<String> set;

    public CategoricalColumnCondition(String columnName, ConditionOp op, String value) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public CategoricalColumnCondition(String columnName, SequenceConditionMode sequenceConditionMode, ConditionOp op, String value) {
        super(columnName, sequenceConditionMode);
        if (op != ConditionOp.Equal && op != ConditionOp.NotEqual) {
            throw new IllegalArgumentException("Invalid condition op: can only use this constructor with Equal or NotEqual conditions");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public CategoricalColumnCondition(String columnName, ConditionOp op, Set<String> set) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    private CategoricalColumnCondition(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="op") ConditionOp op, @JsonProperty(value="value") String value, @JsonProperty(value="set") Set<String> set) {
        super(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
        this.op = op;
        this.value = value;
        this.set = set;
    }

    public CategoricalColumnCondition(String columnName, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<String> set) {
        super(columnName, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = null;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        return this.op.apply(writable.toString(), this.value, this.set);
    }

    @Override
    public String toString() {
        return "CategoricalColumnCondition(columnName=\"" + this.columnName + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : this.value) + ")";
    }

    @Override
    public boolean condition(Object input) {
        return this.op.apply(input.toString(), this.value, this.set);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoricalColumnCondition)) {
            return false;
        }
        CategoricalColumnCondition other = (CategoricalColumnCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionOp this$op = this.getOp();
        ConditionOp other$op = other.getOp();
        if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Set<String> this$set = this.getSet();
        Set<String> other$set = other.getSet();
        return !(this$set == null ? other$set != null : !((Object)this$set).equals(other$set));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CategoricalColumnCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ConditionOp $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Set<String> $set = this.getSet();
        result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
        return result;
    }

    public ConditionOp getOp() {
        return this.op;
    }

    public String getValue() {
        return this.value;
    }

    public Set<String> getSet() {
        return this.set;
    }
}

