/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.columns;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.NumericalColumnAnalysis;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeAnalysis
extends NumericalColumnAnalysis {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss.SSS zzz").withZone(DateTimeZone.UTC);
    private long min;
    private long max;

    private TimeAnalysis(Builder builder) {
        super(builder);
        this.min = builder.min;
        this.max = builder.max;
    }

    @Override
    public String toString() {
        return "TimeAnalysis(min=" + this.min + " (" + formatter.print(this.min) + "),max=" + this.max + " (" + formatter.print(this.max) + ")," + super.toString() + ")";
    }

    @Override
    public double getMinDouble() {
        return this.min;
    }

    @Override
    public double getMaxDouble() {
        return this.max;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Long;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeAnalysis)) {
            return false;
        }
        TimeAnalysis other = (TimeAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMin() != other.getMin()) {
            return false;
        }
        return this.getMax() == other.getMax();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimeAnalysis;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $min = this.getMin();
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $max = this.getMax();
        result = result * 59 + (int)($max >>> 32 ^ $max);
        return result;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public TimeAnalysis() {
    }

    public static class Builder
    extends NumericalColumnAnalysis.Builder<Builder> {
        private long min;
        private long max;

        public Builder min(long min) {
            this.min = min;
            return this;
        }

        public Builder max(long max) {
            this.max = max;
            return this;
        }

        public TimeAnalysis build() {
            return new TimeAnalysis(this);
        }
    }
}

