/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.columns;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;

public class StringAnalysis
implements ColumnAnalysis {
    private int minLength;
    private int maxLength;
    private double meanLength;
    private double sampleStdevLength;
    private double sampleVarianceLength;
    private long countTotal;
    private double[] histogramBuckets;
    private long[] histogramBucketCounts;

    private StringAnalysis(Builder builder) {
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.meanLength = builder.meanLength;
        this.sampleStdevLength = builder.sampleStdevLength;
        this.sampleVarianceLength = builder.sampleVarianceLength;
        this.countTotal = builder.countTotal;
        this.histogramBuckets = builder.histogramBuckets;
        this.histogramBucketCounts = builder.histogramBucketCounts;
    }

    public String toString() {
        return "StringAnalysis(minLen=" + this.minLength + ",maxLen=" + this.maxLength + ",meanLen=" + this.meanLength + ",sampleStDevLen=" + this.sampleStdevLength + ",sampleVarianceLen=" + this.sampleVarianceLength + ",count=" + this.countTotal + ")";
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.String;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public double getMeanLength() {
        return this.meanLength;
    }

    public double getSampleStdevLength() {
        return this.sampleStdevLength;
    }

    public double getSampleVarianceLength() {
        return this.sampleVarianceLength;
    }

    @Override
    public long getCountTotal() {
        return this.countTotal;
    }

    public double[] getHistogramBuckets() {
        return this.histogramBuckets;
    }

    public long[] getHistogramBucketCounts() {
        return this.histogramBucketCounts;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMeanLength(double meanLength) {
        this.meanLength = meanLength;
    }

    public void setSampleStdevLength(double sampleStdevLength) {
        this.sampleStdevLength = sampleStdevLength;
    }

    public void setSampleVarianceLength(double sampleVarianceLength) {
        this.sampleVarianceLength = sampleVarianceLength;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public void setHistogramBuckets(double[] histogramBuckets) {
        this.histogramBuckets = histogramBuckets;
    }

    public void setHistogramBucketCounts(long[] histogramBucketCounts) {
        this.histogramBucketCounts = histogramBucketCounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringAnalysis)) {
            return false;
        }
        StringAnalysis other = (StringAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinLength() != other.getMinLength()) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        if (Double.compare(this.getMeanLength(), other.getMeanLength()) != 0) {
            return false;
        }
        if (Double.compare(this.getSampleStdevLength(), other.getSampleStdevLength()) != 0) {
            return false;
        }
        if (Double.compare(this.getSampleVarianceLength(), other.getSampleVarianceLength()) != 0) {
            return false;
        }
        if (this.getCountTotal() != other.getCountTotal()) {
            return false;
        }
        if (!Arrays.equals(this.getHistogramBuckets(), other.getHistogramBuckets())) {
            return false;
        }
        return Arrays.equals(this.getHistogramBucketCounts(), other.getHistogramBucketCounts());
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinLength();
        result = result * 59 + this.getMaxLength();
        long $meanLength = Double.doubleToLongBits(this.getMeanLength());
        result = result * 59 + (int)($meanLength >>> 32 ^ $meanLength);
        long $sampleStdevLength = Double.doubleToLongBits(this.getSampleStdevLength());
        result = result * 59 + (int)($sampleStdevLength >>> 32 ^ $sampleStdevLength);
        long $sampleVarianceLength = Double.doubleToLongBits(this.getSampleVarianceLength());
        result = result * 59 + (int)($sampleVarianceLength >>> 32 ^ $sampleVarianceLength);
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        result = result * 59 + Arrays.hashCode(this.getHistogramBuckets());
        result = result * 59 + Arrays.hashCode(this.getHistogramBucketCounts());
        return result;
    }

    @ConstructorProperties(value={"minLength", "maxLength", "meanLength", "sampleStdevLength", "sampleVarianceLength", "countTotal", "histogramBuckets", "histogramBucketCounts"})
    public StringAnalysis(int minLength, int maxLength, double meanLength, double sampleStdevLength, double sampleVarianceLength, long countTotal, double[] histogramBuckets, long[] histogramBucketCounts) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.meanLength = meanLength;
        this.sampleStdevLength = sampleStdevLength;
        this.sampleVarianceLength = sampleVarianceLength;
        this.countTotal = countTotal;
        this.histogramBuckets = histogramBuckets;
        this.histogramBucketCounts = histogramBucketCounts;
    }

    public StringAnalysis() {
    }

    public static class Builder {
        private int minLength;
        private int maxLength;
        private double meanLength;
        private double sampleStdevLength;
        private double sampleVarianceLength;
        private long countTotal;
        private double[] histogramBuckets;
        private long[] histogramBucketCounts;

        public Builder minLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder meanLength(double meanLength) {
            this.meanLength = meanLength;
            return this;
        }

        public Builder sampleStdevLength(double sampleStdevLength) {
            this.sampleStdevLength = sampleStdevLength;
            return this;
        }

        public Builder sampleVarianceLength(double sampleVarianceLength) {
            this.sampleVarianceLength = sampleVarianceLength;
            return this;
        }

        public Builder countTotal(long countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        public Builder histogramBuckets(double[] histogramBuckets) {
            this.histogramBuckets = histogramBuckets;
            return this;
        }

        public Builder histogramBucketCounts(long[] histogramBucketCounts) {
            this.histogramBucketCounts = histogramBucketCounts;
            return this;
        }

        public StringAnalysis build() {
            return new StringAnalysis(this);
        }
    }
}

