/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.csv;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataLine;
import org.datavec.api.records.reader.impl.LineRecordReader;
import org.datavec.api.records.reader.impl.csv.SerializableCSVParser;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class CSVRecordReader
extends LineRecordReader {
    private boolean skippedLines = false;
    protected int skipNumLines = 0;
    public static final char DEFAULT_DELIMITER = ',';
    public static final char DEFAULT_QUOTE = '\"';
    public static final String SKIP_NUM_LINES = NAME_SPACE + ".skipnumlines";
    public static final String DELIMITER = NAME_SPACE + ".delimiter";
    public static final String QUOTE = NAME_SPACE + ".quote";
    private SerializableCSVParser csvParser;

    public CSVRecordReader(int skipNumLines) {
        this(skipNumLines, ',');
    }

    public CSVRecordReader(int skipNumLines, char delimiter) {
        this(skipNumLines, delimiter, '\"');
    }

    @Deprecated
    public CSVRecordReader(int skipNumLines, String delimiter) {
        this(skipNumLines, CSVRecordReader.stringDelimToChar(delimiter));
    }

    private static char stringDelimToChar(String delimiter) {
        if (delimiter.length() > 1) {
            throw new UnsupportedOperationException("Multi-character delimiters have been deprecated. For quotes, use CSVRecordReader(int skipNumLines, char delimiter, char quote)");
        }
        return delimiter.charAt(0);
    }

    public CSVRecordReader(int skipNumLines, char delimiter, char quote) {
        this.skipNumLines = skipNumLines;
        this.csvParser = new SerializableCSVParser(delimiter, quote);
    }

    @Deprecated
    public CSVRecordReader(int skipNumLines, String delimiter, String quote) {
        this(skipNumLines, CSVRecordReader.stringDelimToChar(delimiter), CSVRecordReader.stringDelimToChar(quote));
    }

    public CSVRecordReader() {
        this(0, ',');
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.skipNumLines = conf.getInt(SKIP_NUM_LINES, this.skipNumLines);
        this.csvParser = new SerializableCSVParser(conf.getChar(DELIMITER, ','), conf.getChar(QUOTE, '\"'));
    }

    private boolean skipLines() {
        if (!this.skippedLines && this.skipNumLines > 0) {
            for (int i = 0; i < this.skipNumLines; ++i) {
                if (!super.hasNext()) {
                    return false;
                }
                super.next();
            }
            this.skippedLines = true;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.skipLines() && super.hasNext();
    }

    @Override
    public List<Writable> next() {
        if (!this.skipLines()) {
            throw new NoSuchElementException("No next element found!");
        }
        Text t = (Text)super.next().iterator().next();
        String val = t.toString();
        return this.parseLine(val);
    }

    protected List<Writable> parseLine(String line) {
        String[] split;
        try {
            split = this.csvParser.parseLine(line);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Writable> ret = new ArrayList<Writable>();
        for (String s : split) {
            ret.add(new Text(s));
        }
        return ret;
    }

    @Override
    public Record nextRecord() {
        List<Writable> next = this.next();
        URI uri = this.locations == null || this.locations.length < 1 ? null : this.locations[this.splitIndex];
        RecordMetaDataLine meta = new RecordMetaDataLine(this.lineIndex - 1, uri, CSVRecordReader.class);
        return new org.datavec.api.records.impl.Record(next, meta);
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        List<Record> list = super.loadFromMetaData(recordMetaDatas);
        for (Record r : list) {
            String line = r.getRecord().get(0).toString();
            r.setRecord(this.parseLine(line));
        }
        return list;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Reading CSV data from DataInputStream not yet implemented");
    }

    @Override
    public void reset() {
        super.reset();
        this.skippedLines = false;
    }

    @Override
    protected void onLocationOpen(URI location) {
        this.skippedLines = false;
    }
}

