/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.metadata;

import java.net.URI;
import java.util.Arrays;
import org.datavec.api.records.metadata.RecordMetaData;

public class RecordMetaDataComposable
implements RecordMetaData {
    private Class<?> readerClass;
    private RecordMetaData[] meta;

    public RecordMetaDataComposable(RecordMetaData ... recordMetaDatas) {
        this((Class<?>)null, recordMetaDatas);
    }

    public RecordMetaDataComposable(Class<?> readerClass, RecordMetaData ... recordMetaDatas) {
        this.readerClass = readerClass;
        this.meta = recordMetaDatas;
    }

    @Override
    public String getLocation() {
        StringBuilder sb = new StringBuilder();
        sb.append("locations(");
        boolean first = true;
        for (RecordMetaData rmd : this.meta) {
            if (!first) {
                sb.append(",");
            }
            sb.append(rmd.getLocation());
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public URI getURI() {
        return this.meta[0].getURI();
    }

    @Override
    public Class<?> getReaderClass() {
        return this.readerClass;
    }

    public RecordMetaData[] getMeta() {
        return this.meta;
    }

    public void setReaderClass(Class<?> readerClass) {
        this.readerClass = readerClass;
    }

    public void setMeta(RecordMetaData[] meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordMetaDataComposable)) {
            return false;
        }
        RecordMetaDataComposable other = (RecordMetaDataComposable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$readerClass = this.getReaderClass();
        Class<?> other$readerClass = other.getReaderClass();
        if (this$readerClass == null ? other$readerClass != null : !this$readerClass.equals(other$readerClass)) {
            return false;
        }
        return Arrays.deepEquals(this.getMeta(), other.getMeta());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordMetaDataComposable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $readerClass = this.getReaderClass();
        result = result * 59 + ($readerClass == null ? 43 : $readerClass.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMeta());
        return result;
    }

    public String toString() {
        return "RecordMetaDataComposable(readerClass=" + this.getReaderClass() + ", meta=" + Arrays.deepToString(this.getMeta()) + ")";
    }
}

