/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.transform.string.BaseStringTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class MapAllStringsExceptListTransform
extends BaseStringTransform {
    private final Set<String> exclusionSet;
    private final String newValue;

    public MapAllStringsExceptListTransform(String column, String newValue, List<String> exceptions) {
        super(column);
        this.newValue = newValue;
        this.exclusionSet = new HashSet<String>(exceptions);
    }

    @Override
    public Text map(Writable writable) {
        String str = writable.toString();
        if (this.exclusionSet.contains(str)) {
            return new Text(str);
        }
        return new Text(this.newValue);
    }
}

