/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.integer;

import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.transform.BaseColumnsMathOpTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;

public class IntegerColumnsMathOpTransform
extends BaseColumnsMathOpTransform {
    public IntegerColumnsMathOpTransform(String newColumnName, MathOp mathOp, String ... columns) {
        super(newColumnName, mathOp, columns);
    }

    @Override
    protected ColumnMetaData derivedColumnMetaData() {
        return new IntegerMetaData();
    }

    @Override
    protected Writable doOp(Writable ... input) {
        switch (this.mathOp) {
            case Add: {
                int sum = 0;
                for (Writable w : input) {
                    sum += w.toInt();
                }
                return new IntWritable(sum);
            }
            case Subtract: {
                return new IntWritable(input[0].toInt() - input[1].toInt());
            }
            case Multiply: {
                int product = 1;
                for (Writable w : input) {
                    product *= w.toInt();
                }
                return new IntWritable(product);
            }
            case Divide: {
                return new IntWritable(input[0].toInt() / input[1].toInt());
            }
            case Modulus: {
                return new IntWritable(input[0].toInt() % input[1].toInt());
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }
}

