/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Writable;

public class RemoveColumnsTransform
extends BaseTransform {
    private int[] columnsToRemoveIdx;
    private String[] columnsToRemove;
    private Set<Integer> indicesToRemove;

    public RemoveColumnsTransform(String ... columnsToRemove) {
        this.columnsToRemove = columnsToRemove;
    }

    @Override
    public void setInputSchema(Schema schema) {
        super.setInputSchema(schema);
        this.indicesToRemove = new HashSet<Integer>();
        int i = 0;
        this.columnsToRemoveIdx = new int[this.columnsToRemove.length];
        for (String s : this.columnsToRemove) {
            int idx = schema.getIndexOfColumn(s);
            if (idx < 0) {
                throw new RuntimeException("Column \"" + s + "\" not found");
            }
            this.columnsToRemoveIdx[i++] = idx;
            this.indicesToRemove.add(idx);
        }
    }

    @Override
    public Schema transform(Schema schema) {
        int nToRemove = this.columnsToRemove.length;
        int newNumColumns = schema.numColumns() - nToRemove;
        if (newNumColumns <= 0) {
            throw new IllegalStateException("Number of columns after executing operation is " + newNumColumns + " (is <= 0). " + "origColumns = " + schema.getColumnNames() + ", toRemove = " + Arrays.toString(this.columnsToRemove));
        }
        List<String> origNames = schema.getColumnNames();
        List<ColumnMetaData> origMeta = schema.getColumnMetaData();
        HashSet set = new HashSet();
        Collections.addAll(set, this.columnsToRemove);
        ArrayList<String> newNames = new ArrayList<String>(newNumColumns);
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(newNumColumns);
        Iterator<String> namesIter = origNames.iterator();
        Iterator<ColumnMetaData> metaIter = origMeta.iterator();
        while (namesIter.hasNext()) {
            String n = namesIter.next();
            ColumnMetaData t = metaIter.next();
            if (set.contains(n)) continue;
            newNames.add(n);
            newMeta.add(t);
        }
        return schema.newSchema(newNames, newMeta);
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not " + "match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        ArrayList<Writable> outList = new ArrayList<Writable>(writables.size() - this.columnsToRemove.length);
        int i = 0;
        for (Writable w : writables) {
            if (this.indicesToRemove.contains(i++)) continue;
            outList.add(w);
        }
        return outList;
    }

    @Override
    public String toString() {
        return "RemoveColumnsTransform(" + Arrays.toString(this.columnsToRemove) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveColumnsTransform)) {
            return false;
        }
        RemoveColumnsTransform other = (RemoveColumnsTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getColumnsToRemoveIdx(), other.getColumnsToRemoveIdx())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColumnsToRemove(), other.getColumnsToRemove())) {
            return false;
        }
        Set<Integer> this$indicesToRemove = this.getIndicesToRemove();
        Set<Integer> other$indicesToRemove = other.getIndicesToRemove();
        return !(this$indicesToRemove == null ? other$indicesToRemove != null : !((Object)this$indicesToRemove).equals(other$indicesToRemove));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveColumnsTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getColumnsToRemoveIdx());
        result = result * 59 + Arrays.deepHashCode(this.getColumnsToRemove());
        Set<Integer> $indicesToRemove = this.getIndicesToRemove();
        result = result * 59 + ($indicesToRemove == null ? 43 : ((Object)$indicesToRemove).hashCode());
        return result;
    }

    public int[] getColumnsToRemoveIdx() {
        return this.columnsToRemoveIdx;
    }

    public String[] getColumnsToRemove() {
        return this.columnsToRemove;
    }

    public Set<Integer> getIndicesToRemove() {
        return this.indicesToRemove;
    }

    public void setColumnsToRemoveIdx(int[] columnsToRemoveIdx) {
        this.columnsToRemoveIdx = columnsToRemoveIdx;
    }

    public void setColumnsToRemove(String[] columnsToRemove) {
        this.columnsToRemove = columnsToRemove;
    }

    public void setIndicesToRemove(Set<Integer> indicesToRemove) {
        this.indicesToRemove = indicesToRemove;
    }
}

