/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

public abstract class BaseColumnsMathOpTransform
implements Transform {
    protected final String newColumnName;
    protected final MathOp mathOp;
    protected final String[] columns;
    private int[] columnIdxs;
    private Schema inputSchema;

    public BaseColumnsMathOpTransform(String newColumnName, MathOp mathOp, String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("Invalid input: cannot have null/0 columns");
        }
        this.newColumnName = newColumnName;
        this.mathOp = mathOp;
        this.columns = columns;
        switch (mathOp) {
            case Add: {
                if (columns.length >= 2) break;
                throw new IllegalArgumentException("Need 2 or more columns for Add op. Got: " + Arrays.toString(columns));
            }
            case Subtract: {
                if (columns.length == 2) break;
                throw new IllegalArgumentException("Need exactly 2 columns for Subtract op. Got: " + Arrays.toString(columns));
            }
            case Multiply: {
                if (columns.length >= 2) break;
                throw new IllegalArgumentException("Need 2 or more columns for Multiply op. Got: " + Arrays.toString(columns));
            }
            case Divide: {
                if (columns.length == 2) break;
                throw new IllegalArgumentException("Need exactly 2 columns for Divide op. Got: " + Arrays.toString(columns));
            }
            case Modulus: {
                if (columns.length == 2) break;
                throw new IllegalArgumentException("Need exactly 2 columns for Modulus op. Got: " + Arrays.toString(columns));
            }
            case ReverseSubtract: 
            case ReverseDivide: 
            case ScalarMin: 
            case ScalarMax: {
                throw new IllegalArgumentException("Invalid MathOp: cannot use " + (Object)((Object)mathOp) + " with ...ColumnsMathOpTransform");
            }
            default: {
                throw new RuntimeException("Unknown MathOp: " + (Object)((Object)mathOp));
            }
        }
    }

    @Override
    public Schema transform(Schema inputSchema) {
        for (String name : this.columns) {
            if (inputSchema.hasColumn(name)) continue;
            throw new IllegalStateException("Input schema does not have column with name \"" + name + "\"");
        }
        ArrayList<String> newNames = new ArrayList<String>(inputSchema.getColumnNames());
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(inputSchema.getColumnMetaData());
        newNames.add(this.newColumnName);
        newMeta.add(this.derivedColumnMetaData());
        return inputSchema.newSchema(newNames, newMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.columnIdxs = new int[this.columns.length];
        int i = 0;
        for (String name : this.columns) {
            if (!inputSchema.hasColumn(name)) {
                throw new IllegalStateException("Input schema does not have column with name \"" + name + "\"");
            }
            this.columnIdxs[i++] = inputSchema.getIndexOfColumn(name);
        }
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (this.inputSchema == null) {
            throw new IllegalStateException("Input schema has not been set");
        }
        ArrayList<Writable> out = new ArrayList<Writable>(writables);
        Writable[] temp = new Writable[this.columns.length];
        for (int i = 0; i < this.columnIdxs.length; ++i) {
            temp[i] = (Writable)out.get(this.columnIdxs[i]);
        }
        out.add(this.doOp(temp));
        return out;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (List<Writable> step : sequence) {
            out.add(this.map(step));
        }
        return out;
    }

    protected abstract ColumnMetaData derivedColumnMetaData();

    protected abstract Writable doOp(Writable ... var1);
}

