/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.comparator;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.sequence.comparator.BaseColumnComparator;
import org.datavec.api.writable.Writable;

public class NumericalColumnComparator
extends BaseColumnComparator {
    private ColumnType columnType;
    private boolean ascending;

    public NumericalColumnComparator(String columnName) {
        this(columnName, true);
    }

    public NumericalColumnComparator(String columnName, boolean ascending) {
        super(columnName);
        this.ascending = ascending;
    }

    @Override
    public void setSchema(Schema sequenceSchema) {
        super.setSchema(sequenceSchema);
        this.columnType = sequenceSchema.getType(this.columnIdx);
        switch (this.columnType) {
            case Integer: 
            case Long: 
            case Double: 
            case Time: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot apply numerical column comparator on column of type " + (Object)((Object)this.columnType));
            }
        }
    }

    @Override
    protected int compare(Writable w1, Writable w2) {
        int compare;
        switch (this.columnType) {
            case Integer: {
                compare = Integer.compare(w1.toInt(), w2.toInt());
                break;
            }
            case Long: 
            case Time: {
                compare = Long.compare(w1.toLong(), w2.toLong());
                break;
            }
            case Double: {
                compare = Double.compare(w1.toDouble(), w2.toDouble());
                break;
            }
            default: {
                throw new RuntimeException("Cannot apply numerical column comparator on column of type " + (Object)((Object)this.columnType));
            }
        }
        if (this.ascending) {
            return compare;
        }
        return -compare;
    }
}

