/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.writable.Writable;

public class CategoricalMetaData
implements ColumnMetaData {
    private List<String> stateNames;
    private Set<String> stateNamesSet;

    public CategoricalMetaData(String ... stateNames) {
        this(Arrays.asList(stateNames));
    }

    public CategoricalMetaData(List<String> stateNames) {
        this.stateNames = stateNames;
        this.stateNamesSet = new HashSet<String>(stateNames);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Categorical;
    }

    @Override
    public boolean isValid(Writable writable) {
        return this.stateNamesSet.contains(writable.toString());
    }

    @Override
    public CategoricalMetaData clone() {
        return new CategoricalMetaData(this.stateNames);
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CategoricalMetaData(stateNames=[");
        boolean first = true;
        for (String s : this.stateNamesSet) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"").append(s).append("\"");
            first = false;
        }
        sb.append("])");
        return sb.toString();
    }
}

