/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;
import org.datavec.api.transform.schema.Schema;

public class DataAnalysis
implements Serializable {
    private Schema schema;
    private List<ColumnAnalysis> columnAnalysis;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nCol = this.schema.numColumns();
        int maxNameLength = 0;
        for (String s : this.schema.getColumnNames()) {
            maxNameLength = Math.max(maxNameLength, s.length());
        }
        sb.append(String.format("%-6s", "idx")).append(String.format("%-" + (maxNameLength + 8) + "s", "name")).append(String.format("%-15s", "type")).append("analysis").append("\n");
        for (int i = 0; i < nCol; ++i) {
            String colName = this.schema.getName(i);
            ColumnType type = this.schema.getType(i);
            ColumnAnalysis analysis = this.columnAnalysis.get(i);
            String paddedName = String.format("%-" + (maxNameLength + 8) + "s", "\"" + colName + "\"");
            sb.append(String.format("%-6d", i)).append(paddedName).append(String.format("%-15s", new Object[]{type})).append(analysis).append("\n");
        }
        return sb.toString();
    }

    public ColumnAnalysis getColumnAnalysis(String column) {
        return this.columnAnalysis.get(this.schema.getIndexOfColumn(column));
    }

    @ConstructorProperties(value={"schema", "columnAnalysis"})
    public DataAnalysis(Schema schema, List<ColumnAnalysis> columnAnalysis) {
        this.schema = schema;
        this.columnAnalysis = columnAnalysis;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public List<ColumnAnalysis> getColumnAnalysis() {
        return this.columnAnalysis;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setColumnAnalysis(List<ColumnAnalysis> columnAnalysis) {
        this.columnAnalysis = columnAnalysis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataAnalysis)) {
            return false;
        }
        DataAnalysis other = (DataAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema this$schema = this.getSchema();
        Schema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        List<ColumnAnalysis> this$columnAnalysis = this.getColumnAnalysis();
        List<ColumnAnalysis> other$columnAnalysis = other.getColumnAnalysis();
        return !(this$columnAnalysis == null ? other$columnAnalysis != null : !((Object)this$columnAnalysis).equals(other$columnAnalysis));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        List<ColumnAnalysis> $columnAnalysis = this.getColumnAnalysis();
        result = result * 59 + ($columnAnalysis == null ? 43 : ((Object)$columnAnalysis).hashCode());
        return result;
    }
}

