/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.io.filters;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.datavec.api.io.filters.PathFilter;

public class RandomPathFilter
implements PathFilter {
    protected Random random;
    protected String[] extensions;
    protected int maxPaths = 0;

    public RandomPathFilter(Random random, String ... extensions) {
        this(random, extensions, 0);
    }

    public RandomPathFilter(Random random, String[] extensions, int maxPaths) {
        this.random = random;
        this.extensions = extensions;
        this.maxPaths = maxPaths;
    }

    protected boolean accept(String name) {
        if (this.extensions == null || this.extensions.length == 0) {
            return true;
        }
        for (String extension : this.extensions) {
            if (!name.endsWith("." + extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public URI[] filter(URI[] paths) {
        ArrayList<URI> newpaths = new ArrayList<URI>();
        for (URI path : paths) {
            if (this.accept(path.toString())) {
                newpaths.add(path);
            }
            if (this.maxPaths > 0 && newpaths.size() >= this.maxPaths) break;
        }
        Collections.shuffle(newpaths, this.random);
        return newpaths.toArray(new URI[newpaths.size()]);
    }
}

