/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.cloud.storage;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.cloud.types.JobAuthorization;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.transfer.errors.ErrorDetail;

public interface JobStore
extends TemporaryPerJobDataStore {
    public void createJob(UUID var1, PortabilityJob var2) throws IOException;

    public void claimJob(UUID var1, PortabilityJob var2) throws IOException;

    public void updateJobAuthStateToCredsAvailable(UUID var1) throws IOException;

    public void updateJobWithCredentials(UUID var1, PortabilityJob var2) throws IOException;

    public void addErrorsToJob(UUID var1, Collection<ErrorDetail> var2) throws IOException;

    public void addFailureReasonToJob(UUID var1, String var2) throws IOException;

    public void markJobAsFinished(UUID var1, PortabilityJob.State var2) throws IOException;

    public void markJobAsStarted(UUID var1) throws IOException;

    public void markJobAsTimedOut(UUID var1) throws IOException;

    public void remove(UUID var1) throws IOException;

    public PortabilityJob findJob(UUID var1);

    public UUID findFirst(JobAuthorization.State var1);

    default public void addCounts(UUID jobId, Map<String, Integer> newCounts) throws IOException {
    }

    default public Map<String, Integer> getCounts(UUID jobId) {
        return null;
    }

    default public void addBytes(UUID jobId, Long bytes) throws IOException {
    }

    default public void addBytes(UUID jobId, Map<String, Long> bytes) {
    }

    default public Long getBytes(UUID jobId) {
        return null;
    }

    default public Optional<Stack<ExportInformation>> loadJobStack(UUID jobId) {
        return Optional.empty();
    }

    default public void storeJobStack(UUID jobId, Stack<ExportInformation> stack) {
    }

    default public void abandonJob(UUID jobId, String reason) {
    }
}

