/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.cloud.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.datatransferproject.spi.cloud.types.AutoValue_PortabilityJob;
import org.datatransferproject.spi.cloud.types.JobAuthorization;
import org.datatransferproject.types.common.models.DataVertical;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class PortabilityJob {
    public static final String AUTHORIZATION_STATE = "AUTHORIZATION_STATE";
    private static final String DATA_TYPE_KEY = "DATA_TYPE";
    private static final String EXPORT_SERVICE_KEY = "EXPORT_SERVICE";
    private static final String IMPORT_SERVICE_KEY = "IMPORT_SERVICE";
    private static final String EXPORT_INFORMATION_KEY = "EXPORT_INFORMATION";
    private static final String ENCRYPTED_CREDS_KEY = "ENCRYPTED_CREDS_KEY";
    private static final String ENCRYPTED_SESSION_KEY = "ENCRYPTED_SESSION_KEY";
    private static final String ENCRYPTION_SCHEME = "ENCRYPTION_SCHEME";
    private static final String WORKER_INSTANCE_PUBLIC_KEY = "WORKER_INSTANCE_PUBLIC_KEY";
    private static final String WORKER_INSTANCE_ID = "INSTANCE_ID";
    private static final String IMPORT_ENCRYPTED_INITIAL_AUTH_DATA = "IMPORT_ENCRYPTED_INITIAL_AUTH_DATA";
    private static final String EXPORT_ENCRYPTED_INITIAL_AUTH_DATA = "EXPORT_ENCRYPTED_INITIAL_AUTH_DATA";
    private static final String JOB_STATE = "JOB_STATE";
    private static final String TRANSFER_MODE = "TRANSFER_MODE";
    private static final String FAILURE_REASON = "FAILURE_REASON";
    private static final String NUMBER_OF_FAILED_FILES_KEY = "NUM_FAILED_FILES";
    private static final String USER_TIMEZONE = "USER_TIMEZONE";
    private static final String USER_LOCALE = "USER_LOCALE";
    private static final String USER_ALIAS = "USER_ALIAS";

    public static Builder builder() {
        Instant now = Instant.now();
        return new AutoValue_PortabilityJob.Builder().setState(State.NEW).setCreatedTimestamp(now).setLastUpdateTimestamp(now).setFailureReason(null);
    }

    public static PortabilityJob fromMap(Map<String, Object> properties) {
        Instant now = Instant.now();
        String encryptedAuthData = properties.containsKey(ENCRYPTED_CREDS_KEY) ? (String)properties.get(ENCRYPTED_CREDS_KEY) : null;
        String encodedPublicKey = properties.containsKey(WORKER_INSTANCE_PUBLIC_KEY) ? (String)properties.get(WORKER_INSTANCE_PUBLIC_KEY) : null;
        String instanceId = properties.containsKey(WORKER_INSTANCE_ID) ? (String)properties.get(WORKER_INSTANCE_ID) : null;
        String encryptedExportInitialAuthData = properties.containsKey(EXPORT_ENCRYPTED_INITIAL_AUTH_DATA) ? (String)properties.get(EXPORT_ENCRYPTED_INITIAL_AUTH_DATA) : null;
        String encryptedImportInitialAuthData = properties.containsKey(IMPORT_ENCRYPTED_INITIAL_AUTH_DATA) ? (String)properties.get(IMPORT_ENCRYPTED_INITIAL_AUTH_DATA) : null;
        State state = properties.containsKey(JOB_STATE) ? State.valueOf((String)properties.get(JOB_STATE)) : State.NEW;
        String failureReason = properties.containsKey(FAILURE_REASON) ? (String)properties.get(FAILURE_REASON) : null;
        TimeZone userTimeZone = properties.containsKey(USER_TIMEZONE) ? (TimeZone)properties.get(USER_TIMEZONE) : null;
        String userLocale = properties.containsKey(USER_LOCALE) ? (String)properties.get(USER_LOCALE) : null;
        String userAlias = properties.containsKey(USER_ALIAS) ? (String)properties.get(USER_ALIAS) : null;
        TransferMode transferMode = properties.containsKey(TRANSFER_MODE) ? TransferMode.valueOf((String)properties.get(TRANSFER_MODE)) : TransferMode.DATA_TRANSFER;
        DataVertical dataType = properties.containsKey(DATA_TYPE_KEY) ? DataVertical.fromDataType((String)((String)properties.get(DATA_TYPE_KEY))) : null;
        return PortabilityJob.builder().setState(state).setExportService((String)properties.get(EXPORT_SERVICE_KEY)).setImportService((String)properties.get(IMPORT_SERVICE_KEY)).setTransferDataType(dataType).setExportInformation((String)properties.get(EXPORT_INFORMATION_KEY)).setCreatedTimestamp(now).setLastUpdateTimestamp(now).setFailureReason(failureReason).setJobAuthorization(JobAuthorization.builder().setState(JobAuthorization.State.valueOf((String)properties.get(AUTHORIZATION_STATE))).setEncryptionScheme((String)properties.get(ENCRYPTION_SCHEME)).setEncryptedAuthData(encryptedAuthData).setInstanceId(instanceId).setSessionSecretKey((String)properties.get(ENCRYPTED_SESSION_KEY)).setAuthPublicKey(encodedPublicKey).setEncryptedInitialExportAuthData(encryptedExportInitialAuthData).setEncryptedInitialImportAuthData(encryptedImportInitialAuthData).build()).setUserTimeZone(userTimeZone).setUserLocale(userLocale).setUserAlias(userAlias).setTransferMode(transferMode).build();
    }

    private static void isUnset(String ... strings) {
        for (String str : strings) {
            Preconditions.checkState((boolean)Strings.isNullOrEmpty((String)str));
        }
    }

    private static void isSet(String ... strings) {
        for (String str : strings) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)str) ? 1 : 0) != 0);
        }
    }

    @JsonProperty(value="state")
    public abstract State state();

    @JsonProperty(value="exportService")
    public abstract String exportService();

    @JsonProperty(value="importService")
    public abstract String importService();

    @JsonProperty(value="transferDataType")
    public abstract DataVertical transferDataType();

    @Nullable
    @JsonProperty(value="exportInformation")
    public abstract String exportInformation();

    @JsonProperty(value="createdTimestamp")
    public abstract Instant createdTimestamp();

    @JsonProperty(value="lastUpdateTimestamp")
    public abstract Instant lastUpdateTimestamp();

    @JsonProperty(value="jobAuthorization")
    public abstract JobAuthorization jobAuthorization();

    @Nullable
    @JsonProperty(value="failureReason")
    public abstract String failureReason();

    @Nullable
    @JsonProperty(value="userTimeZone")
    public abstract TimeZone userTimeZone();

    @Nullable
    @JsonProperty(value="userLocale")
    public abstract String userLocale();

    @Nullable
    @JsonProperty(value="userAlias")
    public abstract String userAlias();

    @Nullable
    @JsonProperty(value="transferMode")
    public abstract TransferMode transferMode();

    public abstract Builder toBuilder();

    public Map<String, Object> toMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)DATA_TYPE_KEY, (Object)this.transferDataType().getDataType()).put((Object)EXPORT_SERVICE_KEY, (Object)this.exportService()).put((Object)IMPORT_SERVICE_KEY, (Object)this.importService()).put((Object)AUTHORIZATION_STATE, (Object)this.jobAuthorization().state().toString()).put((Object)JOB_STATE, (Object)this.state().toString());
        if (this.jobAuthorization().sessionSecretKey() != null) {
            builder.put((Object)ENCRYPTED_SESSION_KEY, (Object)this.jobAuthorization().sessionSecretKey());
        }
        if (null != this.exportInformation()) {
            builder.put((Object)EXPORT_INFORMATION_KEY, (Object)this.exportInformation());
        }
        if (null != this.jobAuthorization().authPublicKey()) {
            builder.put((Object)WORKER_INSTANCE_PUBLIC_KEY, (Object)this.jobAuthorization().authPublicKey());
        }
        if (null != this.jobAuthorization().instanceId()) {
            builder.put((Object)WORKER_INSTANCE_ID, (Object)this.jobAuthorization().instanceId());
        }
        if (null != this.jobAuthorization().encryptedAuthData()) {
            builder.put((Object)ENCRYPTED_CREDS_KEY, (Object)this.jobAuthorization().encryptedAuthData());
        }
        if (null != this.failureReason()) {
            builder.put((Object)FAILURE_REASON, (Object)this.failureReason());
        }
        builder.put((Object)ENCRYPTION_SCHEME, (Object)(null != this.jobAuthorization().encryptionScheme() ? this.jobAuthorization().encryptionScheme() : "jwe"));
        if (null != this.jobAuthorization().encryptedInitialExportAuthData()) {
            builder.put((Object)EXPORT_ENCRYPTED_INITIAL_AUTH_DATA, (Object)this.jobAuthorization().encryptedInitialExportAuthData());
        }
        if (null != this.jobAuthorization().encryptedInitialImportAuthData()) {
            builder.put((Object)IMPORT_ENCRYPTED_INITIAL_AUTH_DATA, (Object)this.jobAuthorization().encryptedInitialImportAuthData());
        }
        if (null != this.userTimeZone()) {
            builder.put((Object)USER_TIMEZONE, (Object)this.userTimeZone());
        }
        if (null != this.userLocale()) {
            builder.put((Object)USER_LOCALE, (Object)this.userLocale());
        }
        if (null != this.userAlias()) {
            builder.put((Object)USER_ALIAS, (Object)this.userAlias());
        }
        if (null != this.transferMode()) {
            builder.put((Object)TRANSFER_MODE, (Object)this.transferMode().toString());
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return PortabilityJob.builder();
        }

        public abstract PortabilityJob build();

        @JsonProperty(value="state")
        public abstract Builder setState(State var1);

        @JsonProperty(value="exportService")
        public abstract Builder setExportService(String var1);

        @JsonProperty(value="importService")
        public abstract Builder setImportService(String var1);

        @JsonProperty(value="transferDataType")
        public abstract Builder setTransferDataType(DataVertical var1);

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="exportInformation")
        public abstract Builder setExportInformation(String var1);

        @JsonProperty(value="createdTimestamp")
        public abstract Builder setCreatedTimestamp(Instant var1);

        @JsonProperty(value="lastUpdateTimestamp")
        public abstract Builder setLastUpdateTimestamp(Instant var1);

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="failureReason")
        public abstract Builder setFailureReason(String var1);

        @JsonProperty(value="jobAuthorization")
        public Builder setAndValidateJobAuthorization(JobAuthorization jobAuthorization) {
            switch (jobAuthorization.state()) {
                case INITIAL: 
                case CREDS_AVAILABLE: {
                    PortabilityJob.isUnset(jobAuthorization.encryptedAuthData());
                    break;
                }
                case CREDS_ENCRYPTION_KEY_GENERATED: {
                    PortabilityJob.isSet(jobAuthorization.authPublicKey());
                    PortabilityJob.isUnset(jobAuthorization.encryptedAuthData());
                    break;
                }
                case CREDS_STORED: {
                    PortabilityJob.isSet(jobAuthorization.authPublicKey(), jobAuthorization.encryptedAuthData());
                    break;
                }
                case TIMED_OUT: {
                    throw new RuntimeException("Authorization timed out, can't validate.");
                }
            }
            return this.setJobAuthorization(jobAuthorization);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="userTimeZone")
        public abstract Builder setUserTimeZone(TimeZone var1);

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="userLocale")
        public abstract Builder setUserLocale(String var1);

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="userAlias")
        public abstract Builder setUserAlias(String var1);

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="transferMode")
        public abstract Builder setTransferMode(TransferMode var1);

        protected abstract Builder setJobAuthorization(JobAuthorization var1);
    }

    public static enum TransferMode {
        DATA_TRANSFER,
        SIZE_CALCULATION;

    }

    public static enum State {
        NEW,
        IN_PROGRESS,
        COMPLETE,
        ERROR,
        CANCELED,
        PREEMPTED;

    }
}

