/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.api.transport;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.datatransferproject.spi.api.transport.RemoteFileStreamer;
import org.datatransferproject.types.common.DownloadableItem;

public class UrlGetStreamer
implements RemoteFileStreamer {
    @Override
    public InputStream get(String remoteUrl) throws IOException {
        return new BufferedInputStream(UrlGetStreamer.toUrl(remoteUrl).openStream());
    }

    @Override
    public InputStream get(DownloadableItem downloadableItem) throws IOException {
        Preconditions.checkState((downloadableItem.getFetchableUrl() != null ? 1 : 0) != 0, (Object)"trying to download incomplete DownloadableItem: missing fetchable URL");
        Preconditions.checkState((!downloadableItem.isInTempStore() ? 1 : 0) != 0, (String)"trying to re-download an already stored item: \"%s\"", (Object)downloadableItem.getFetchableUrl());
        return this.get(downloadableItem.getFetchableUrl());
    }

    private static URL toUrl(String url) throws IOException {
        try {
            return new URI(url).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IOException(String.format("invalid URL: \"%s\"", url), e);
        }
    }
}

