/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.api.transport;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.datatransferproject.spi.api.transport.RemoteFileStreamer;
import org.datatransferproject.spi.api.transport.UrlGetStreamer;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.types.common.DownloadableFile;
import org.datatransferproject.types.common.DownloadableItem;

public class JobFileStream {
    private final RemoteFileStreamer remoteFileStreamer;

    @VisibleForTesting
    public JobFileStream(RemoteFileStreamer remoteFileStreamer) {
        this.remoteFileStreamer = remoteFileStreamer;
    }

    public JobFileStream() {
        this(new UrlGetStreamer());
    }

    public InputStream streamFile(DownloadableFile downloadableFile, UUID jobId, TemporaryPerJobDataStore jobStore) throws IOException {
        Preconditions.checkState((downloadableFile.getFetchableUrl() != null ? 1 : 0) != 0, (Object)"missing fetchable URL for file");
        if (downloadableFile.isInTempStore()) {
            return jobStore.getStream(jobId, downloadableFile.getFetchableUrl()).getStream();
        }
        return this.remoteFileStreamer.get((DownloadableItem)downloadableFile);
    }
}

