/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security.jwe;

import com.nimbusds.jose.jwk.RSAKey;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.UUID;
import org.datatransferproject.spi.transfer.security.PublicKeySerializer;
import org.datatransferproject.spi.transfer.security.SecurityException;

public class JWEPublicKeySerializer
implements PublicKeySerializer {
    public boolean canHandle(String scheme) {
        return "jwe".equals(scheme);
    }

    public String serialize(byte[] encodedPublicKey) throws SecurityException {
        PublicKey publicKey = JWEPublicKeySerializer.parse(encodedPublicKey);
        return this.serialize(publicKey);
    }

    private String serialize(PublicKey publicKey) throws SecurityException {
        String kid = UUID.randomUUID().toString();
        RSAKey jwk = new RSAKey.Builder((RSAPublicKey)publicKey).keyID(kid).build();
        return jwk.toString();
    }

    private static PublicKey parse(byte[] encoded) {
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePublic(new X509EncodedKeySpec(encoded));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException("InvalidKeySpecException generating PublicKey, encoded: " + encoded, e);
        }
    }
}

