/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security.cleartext;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.security.TransferKeyGenerator;

public class ClearTextKeyGenerator
implements TransferKeyGenerator {
    private static final String ALGORITHM = "RSA";
    private final Monitor monitor;

    public ClearTextKeyGenerator(Monitor monitor) {
        this.monitor = monitor;
    }

    public TransferKeyGenerator.WorkerKeyPair generate() {
        KeyPairGenerator kpg = null;
        try {
            kpg = KeyPairGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            this.monitor.severe(() -> "NoSuchAlgorithmException for: RSA", new Object[]{e});
            throw new RuntimeException("NoSuchAlgorithmException generating key", e);
        }
        kpg.initialize(1024);
        final KeyPair keyPair = kpg.genKeyPair();
        return new TransferKeyGenerator.WorkerKeyPair(){

            public String getInstanceId() {
                return UUID.randomUUID().toString();
            }

            public byte[] getEncodedPublicKey() {
                return keyPair.getPublic().getEncoded();
            }

            public byte[] getEncodedPrivateKey() {
                return keyPair.getPrivate().getEncoded();
            }
        };
    }
}

