/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.smugmug;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.TypeManager;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.smugmug.media.SmugMugMediaImporter;
import org.datatransferproject.transfer.smugmug.photos.SmugMugPhotosExporter;
import org.datatransferproject.transfer.smugmug.photos.SmugMugPhotosImporter;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class SmugMugTransferExtension
implements TransferExtension {
    private static final ImmutableList<DataVertical> SUPPORTED_TYPES = ImmutableList.of((Object)DataVertical.PHOTOS, (Object)DataVertical.MEDIA);
    private static final String SMUGMUG_KEY = "SMUGMUG_KEY";
    private static final String SMUGMUG_SECRET = "SMUGMUG_SECRET";
    private ImmutableMap<DataVertical, Importer> importerMap;
    private SmugMugPhotosExporter exporter;
    private boolean initialized = false;

    public String getServiceId() {
        return "SmugMug";
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized, (Object)"Trying to call getExporter before initalizing SmugMugTransferExtension");
        Preconditions.checkArgument((boolean)SUPPORTED_TYPES.contains((Object)transferDataType), (Object)("Export of " + String.valueOf(transferDataType) + " not supported by SmugMug"));
        return this.exporter;
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized, (Object)"Trying to call getImporter before initalizing SmugMugTransferExtension");
        Preconditions.checkArgument((boolean)SUPPORTED_TYPES.contains((Object)transferDataType), (Object)("Import of " + String.valueOf(transferDataType) + " not supported by SmugMug"));
        return (Importer)this.importerMap.get((Object)transferDataType);
    }

    public void initialize(ExtensionContext context) {
        AppCredentials appCredentials;
        Monitor monitor = context.getMonitor();
        if (this.initialized) {
            monitor.severe(() -> "SmugMugTransferExtension already initailized.", new Object[0]);
            return;
        }
        TemporaryPerJobDataStore jobStore = (TemporaryPerJobDataStore)context.getService(TemporaryPerJobDataStore.class);
        try {
            appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials(SMUGMUG_KEY, SMUGMUG_SECRET);
        }
        catch (IOException e) {
            monitor.info(() -> String.format("Unable to retrieve SmugMug AppCredentials. Did you set %s and %s?", SMUGMUG_KEY, SMUGMUG_SECRET), new Object[]{e});
            return;
        }
        ObjectMapper mapper = ((TypeManager)context.getService(TypeManager.class)).getMapper();
        this.exporter = new SmugMugPhotosExporter(appCredentials, mapper, jobStore, monitor);
        ImmutableMap.Builder importerBuilder = ImmutableMap.builder();
        importerBuilder.put((Object)DataVertical.PHOTOS, (Object)new SmugMugPhotosImporter(jobStore, appCredentials, mapper, monitor));
        importerBuilder.put((Object)DataVertical.MEDIA, (Object)new SmugMugMediaImporter(jobStore, appCredentials, mapper, monitor));
        this.importerMap = importerBuilder.build();
        this.initialized = true;
    }
}

