/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.transformer.calendar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.datatransferproject.transfer.microsoft.transformer.TransformerContext;
import org.datatransferproject.transfer.microsoft.transformer.common.TransformerHelper;
import org.datatransferproject.types.common.models.calendar.CalendarAttendeeModel;
import org.datatransferproject.types.common.models.calendar.CalendarEventModel;

public class ToCalendarEventModelTransformer
implements BiFunction<Map<String, Object>, TransformerContext, CalendarEventModel> {
    @Override
    public CalendarEventModel apply(Map<String, Object> event, TransformerContext context) {
        if (!"singleInstance".equals(event.get("type"))) {
            return null;
        }
        String calendarId = context.getProperty("calendar.id");
        String title = (String)event.getOrDefault("subject", "");
        String location = TransformerHelper.getOrDefault("location", "displayName", event, "");
        String notes = TransformerHelper.getOrDefault("body", "content", event, "");
        List rawAttendees = event.getOrDefault("attendees", Collections.emptyList());
        ArrayList<CalendarAttendeeModel> attendees = new ArrayList<CalendarAttendeeModel>();
        for (Object rawAttendee : rawAttendees) {
            CalendarAttendeeModel attendee = context.transform(CalendarAttendeeModel.class, rawAttendee);
            if (attendee == null) continue;
            attendees.add(attendee);
        }
        CalendarEventModel.CalendarEventTime startTime = context.transform(CalendarEventModel.CalendarEventTime.class, event.get("start"));
        if (startTime == null) {
            context.problem("Could not parse start time. Skipping event.");
            return null;
        }
        CalendarEventModel.CalendarEventTime endTime = context.transform(CalendarEventModel.CalendarEventTime.class, event.get("end"));
        if (endTime == null) {
            context.problem("Could not parse end time. Skipping event.");
            return null;
        }
        return new CalendarEventModel(calendarId, title, notes, attendees, location, startTime, endTime, null);
    }
}

