/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.datatransferproject.transfer.microsoft.DataChunk;

public class StreamChunker {
    private final int chunkSizeBytes;
    private final InputStream inputStream;
    private long streamByteOffset = 0L;

    public StreamChunker(int chunkSizeBytes, InputStream inputStream) {
        this.inputStream = inputStream;
        this.chunkSizeBytes = chunkSizeBytes;
    }

    public Optional<DataChunk> nextChunk() throws IOException {
        byte[] chunkOfData = this.inputStream.readNBytes(this.chunkSizeBytes);
        Optional<DataChunk> resp = chunkOfData.length == 0 ? Optional.empty() : Optional.of(DataChunk.builder().setChunk(chunkOfData).setStreamByteOffset(this.streamByteOffset).build());
        this.streamByteOffset += (long)chunkOfData.length;
        return resp;
    }
}

