/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.transformer.contacts;

import ezvcard.VCard;
import ezvcard.parameter.TelephoneType;
import ezvcard.property.Address;
import ezvcard.property.Birthday;
import ezvcard.property.Email;
import ezvcard.property.Organization;
import ezvcard.property.StructuredName;
import java.util.Map;
import java.util.function.BiFunction;
import org.datatransferproject.transfer.microsoft.transformer.TransformerContext;
import org.datatransferproject.transfer.microsoft.transformer.common.TransformerHelper;

public class ToVCardTransformer
implements BiFunction<Map<String, Object>, TransformerContext, VCard> {
    @Override
    public VCard apply(Map<String, Object> map, TransformerContext context) {
        VCard card = new VCard();
        this.copyNames(map, card);
        this.copyPersonData(map, card, context);
        this.copyBusinessData(map, card, context);
        TransformerHelper.getList("categories", map).ifPresent(v -> v.forEach(xva$0 -> card.setCategories(new String[]{xva$0})));
        TransformerHelper.getString("personalNotes", map).ifPresent(arg_0 -> ((VCard)card).addNote(arg_0));
        this.copyExtendedData(map, card);
        return card;
    }

    private void copyNames(Map<String, Object> map, VCard card) {
        String givenName = (String)map.get("givenName");
        String surname = (String)map.get("surname");
        StructuredName structuredName = new StructuredName();
        structuredName.setFamily(surname);
        structuredName.setGiven(givenName);
        TransformerHelper.getString("middleName", map).ifPresent(v -> structuredName.getAdditionalNames().add(v));
        TransformerHelper.getString("title", map).ifPresent(v -> structuredName.getPrefixes().add(v));
        card.setStructuredName(structuredName);
        TransformerHelper.getString("displayName", map).ifPresent(arg_0 -> ((VCard)card).setFormattedName(arg_0));
        TransformerHelper.getString("nickName", map).ifPresent(xva$0 -> card.setNickname(new String[]{xva$0}));
    }

    private void copyPersonData(Map<String, Object> map, VCard card, TransformerContext context) {
        TransformerHelper.getMap("homeAddress", map).ifPresent(v -> card.addAddress(context.transform(Address.class, v)));
        this.copyEmail(map, card);
        this.copyPhones("homePhones", TelephoneType.HOME, map, card);
        TransformerHelper.getString("mobilePhone", map).ifPresent(v -> card.addTelephoneNumber(v, new TelephoneType[]{TelephoneType.CELL}));
        TransformerHelper.getString("birthday", map).ifPresent(v -> card.setBirthday(new Birthday(v)));
    }

    private void copyEmail(Map<String, Object> map, VCard card) {
        TransformerHelper.getListMap("emailAddresses", map).ifPresent(v -> v.forEach(email -> TransformerHelper.getString("address", email).ifPresent(addr -> card.addEmail(new Email(addr)))));
    }

    private void copyBusinessData(Map<String, Object> map, VCard card, TransformerContext context) {
        TransformerHelper.getMap("businessAddress", map).ifPresent(v -> card.addAddress(context.transform(Address.class, v)));
        TransformerHelper.getMap("otherAddress", map).ifPresent(v -> card.addAddress(context.transform(Address.class, v)));
        TransformerHelper.getString("jobTitle", map).ifPresent(arg_0 -> ((VCard)card).addTitle(arg_0));
        TransformerHelper.getString("companyName", map).ifPresent(v -> {
            Organization organization = new Organization();
            organization.getValues().add(v);
            card.addOrganization(organization);
        });
        TransformerHelper.getString("profession", map).ifPresent(arg_0 -> ((VCard)card).addExpertise(arg_0));
        this.copyPhones("businessPhones", TelephoneType.WORK, map, card);
    }

    private void copyPhones(String fieldName, TelephoneType type, Map<String, Object> map, VCard card) {
        TransformerHelper.getList(fieldName, map).ifPresent(v -> v.forEach(number -> card.addTelephoneNumber(number, new TelephoneType[]{type})));
    }

    private void copyExtendedData(Map<String, Object> map, VCard card) {
        TransformerHelper.getString("manager", map).ifPresent(v -> card.setExtendedProperty("X-Manager", v));
        TransformerHelper.getString("spouseName", map).ifPresent(v -> card.setExtendedProperty("X-Spouse", v));
    }
}

