/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.calendar;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import okhttp3.OkHttpClient;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.microsoft.common.RequestHelper;
import org.datatransferproject.transfer.microsoft.transformer.TransformResult;
import org.datatransferproject.transfer.microsoft.transformer.TransformerService;
import org.datatransferproject.types.common.models.calendar.CalendarContainerResource;
import org.datatransferproject.types.common.models.calendar.CalendarEventModel;
import org.datatransferproject.types.common.models.calendar.CalendarModel;
import org.datatransferproject.types.transfer.auth.TokenAuthData;

public class MicrosoftCalendarImporter
implements Importer<TokenAuthData, CalendarContainerResource> {
    private static final String CALENDAR_SUBPATH = "/v1.0/me/calendars";
    private static final String EVENT_SUBPATH = "/v1.0/me/calendars/%s/events";
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;
    private final TransformerService transformerService;
    private final String baseUrl;

    public MicrosoftCalendarImporter(String baseUrl, OkHttpClient client, ObjectMapper objectMapper, TransformerService transformerService) {
        this.client = client;
        this.objectMapper = objectMapper;
        this.transformerService = transformerService;
        this.baseUrl = baseUrl;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentImportExecutor, TokenAuthData authData, CalendarContainerResource data) throws Exception {
        for (CalendarModel calendar : data.getCalendars()) {
            idempotentImportExecutor.executeAndSwallowIOExceptions(calendar.getId(), calendar.getName(), () -> this.importCalendar(authData, calendar));
        }
        ArrayList<Map<String, Object>> eventRequests = new ArrayList<Map<String, Object>>();
        int requestId = 1;
        for (CalendarEventModel event : data.getEvents()) {
            String importedId = (String)((Object)idempotentImportExecutor.getCachedValue(event.getCalendarId()));
            Map<String, Object> request = this.createRequestItem(event, requestId, String.format(EVENT_SUBPATH, importedId));
            ++requestId;
            eventRequests.add(request);
        }
        RequestHelper.BatchResponse eventResponse = RequestHelper.batchRequest(authData, eventRequests, this.baseUrl, this.client, this.objectMapper);
        if (ImportResult.ResultType.OK != eventResponse.getResult().getType()) {
            return eventResponse.getResult();
        }
        return eventResponse.getResult();
    }

    private String importCalendar(TokenAuthData authData, CalendarModel calendar) throws Exception {
        ArrayList<Map<String, Object>> calendarRequests = new ArrayList<Map<String, Object>>();
        Map<String, Object> request = this.createRequestItem(calendar, 1, CALENDAR_SUBPATH);
        calendarRequests.add(request);
        RequestHelper.BatchResponse calendarResponse = RequestHelper.batchRequest(authData, calendarRequests, this.baseUrl, this.client, this.objectMapper);
        if (ImportResult.ResultType.OK != calendarResponse.getResult().getType()) {
            throw new IOException("Problem importing calendar: " + String.valueOf(calendarResponse.getResult()));
        }
        Map body = (Map)calendarResponse.getBatchResponse().get(0).get("body");
        return (String)body.get("id");
    }

    private Map<String, Object> createRequestItem(Object item, int id, String url) throws Exception {
        TransformResult<LinkedHashMap> result = this.transformerService.transform(LinkedHashMap.class, item);
        if (result.getProblems() != null && !result.getProblems().isEmpty()) {
            throw new IOException("Problem transforming request: " + result.getProblems().get(0));
        }
        LinkedHashMap contact = result.getTransformed();
        return RequestHelper.createRequest(id, url, contact);
    }
}

