/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.transformer.calendar;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.function.BiFunction;
import org.datatransferproject.transfer.microsoft.transformer.TransformerContext;
import org.datatransferproject.types.common.models.calendar.CalendarEventModel;

public class ToCalendarEventTimeTransformer
implements BiFunction<Map<String, String>, TransformerContext, CalendarEventModel.CalendarEventTime> {
    @Override
    public CalendarEventModel.CalendarEventTime apply(Map<String, String> time, TransformerContext context) {
        if (time == null) {
            return null;
        }
        String dateTimeValue = time.get("dateTime");
        String timeZone = time.get("timeZone");
        if (dateTimeValue == null || timeZone == null) {
            return null;
        }
        try {
            OffsetDateTime dateTime = ZonedDateTime.of(LocalDateTime.parse(dateTimeValue), ZoneId.of(timeZone)).toOffsetDateTime();
            return new CalendarEventModel.CalendarEventTime(dateTime, false);
        }
        catch (DateTimeException e) {
            context.problem(e.getMessage());
            return null;
        }
    }
}

