/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.transformer;

import ezvcard.VCard;
import ezvcard.property.Address;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.datatransferproject.transfer.microsoft.transformer.TransformResult;
import org.datatransferproject.transfer.microsoft.transformer.TransformerContext;
import org.datatransferproject.transfer.microsoft.transformer.TransformerService;
import org.datatransferproject.transfer.microsoft.transformer.calendar.ToCalendarAttendeeModelTransformer;
import org.datatransferproject.transfer.microsoft.transformer.calendar.ToCalendarEventModelTransformer;
import org.datatransferproject.transfer.microsoft.transformer.calendar.ToCalendarEventTimeTransformer;
import org.datatransferproject.transfer.microsoft.transformer.calendar.ToCalendarModelTransformer;
import org.datatransferproject.transfer.microsoft.transformer.calendar.ToGraphCalendarTransformer;
import org.datatransferproject.transfer.microsoft.transformer.calendar.ToGraphEventTransformer;
import org.datatransferproject.transfer.microsoft.transformer.contacts.ToGraphAddressTransformer;
import org.datatransferproject.transfer.microsoft.transformer.contacts.ToGraphContactTransformer;
import org.datatransferproject.transfer.microsoft.transformer.contacts.ToVCardAddressTransformer;
import org.datatransferproject.transfer.microsoft.transformer.contacts.ToVCardTransformer;
import org.datatransferproject.types.common.models.calendar.CalendarAttendeeModel;
import org.datatransferproject.types.common.models.calendar.CalendarEventModel;
import org.datatransferproject.types.common.models.calendar.CalendarModel;

public class TransformerServiceImpl
implements TransformerService {
    Map<TransformKey, BiFunction<?, ?, ?>> cache = new HashMap();

    public TransformerServiceImpl() {
        this.initContactTransformers();
        this.initCalendarTransformers();
    }

    @Override
    public <T> TransformResult<T> transform(Class<T> resultType, Object input) {
        return this.transform(resultType, input, new HashMap<String, String>());
    }

    @Override
    public <T> TransformResult<T> transform(Class<T> resultType, Object input, Map<String, String> properties) {
        TransformerContextImpl context = new TransformerContextImpl(properties);
        T dataType = this.transform(resultType, input, context);
        return new TransformResult<T>(dataType, context.getProblems());
    }

    private <T> T transform(Class<T> resultType, Object input, TransformerContext context) {
        Objects.requireNonNull(resultType, "No result type specified");
        Objects.requireNonNull(input, "No input specified");
        TransformKey key = new TransformKey(input.getClass(), resultType);
        BiFunction function = this.cache.computeIfAbsent(key, v -> {
            throw new IllegalArgumentException("Unsupported transformation: " + input.getClass().getName() + ":" + String.valueOf(resultType));
        });
        return (T)function.apply(input, context);
    }

    private void initContactTransformers() {
        this.cache.put(new TransformKey(LinkedHashMap.class, VCard.class), new ToVCardTransformer());
        this.cache.put(new TransformKey(LinkedHashMap.class, Address.class), new ToVCardAddressTransformer());
        this.cache.put(new TransformKey(VCard.class, LinkedHashMap.class), new ToGraphContactTransformer());
        this.cache.put(new TransformKey(Address.class, LinkedHashMap.class), new ToGraphAddressTransformer());
    }

    private void initCalendarTransformers() {
        this.cache.put(new TransformKey(LinkedHashMap.class, CalendarModel.class), new ToCalendarModelTransformer());
        this.cache.put(new TransformKey(LinkedHashMap.class, CalendarEventModel.class), new ToCalendarEventModelTransformer());
        this.cache.put(new TransformKey(LinkedHashMap.class, CalendarEventModel.CalendarEventTime.class), new ToCalendarEventTimeTransformer());
        this.cache.put(new TransformKey(LinkedHashMap.class, CalendarAttendeeModel.class), new ToCalendarAttendeeModelTransformer());
        this.cache.put(new TransformKey(CalendarModel.class, LinkedHashMap.class), new ToGraphCalendarTransformer());
        this.cache.put(new TransformKey(CalendarEventModel.class, LinkedHashMap.class), new ToGraphEventTransformer());
    }

    private class TransformKey {
        private Class<?> from;
        private Class<?> to;

        public TransformKey(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransformKey that = (TransformKey)o;
            return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }

    private class TransformerContextImpl
    implements TransformerContext {
        private final List<String> problems = new ArrayList<String>();
        private final Map<String, String> properties;

        public TransformerContextImpl(Map<String, String> properties) {
            this.properties = properties;
        }

        @Override
        public <T> T transform(Class<T> resultType, Object input) {
            if (input == null) {
                return null;
            }
            return TransformerServiceImpl.this.transform(resultType, input, this);
        }

        @Override
        public void problem(String message) {
            this.problems.add(message);
        }

        @Override
        public List<String> getProblems() {
            return this.problems;
        }

        @Override
        public String getProperty(String key) {
            return this.properties.get(key);
        }

        @Override
        public void setProperty(String key, String value) {
            this.properties.put(key, value);
        }
    }
}

