/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.media;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.datatransferproject.transfer.microsoft.driveModels.MicrosoftDriveItemsResponse;
import org.datatransferproject.transfer.microsoft.driveModels.MicrosoftSpecialFolder;

public class MicrosoftMediaInterface {
    private static final String BASE_GRAPH_URL = "https://graph.microsoft.com";
    private static final String ODATA_TOP = "top";
    private static final int PAGE_SIZE = 50;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final HttpTransport httpTransport = new NetHttpTransport();
    private final Credential credential;
    private final JsonFactory jsonFactory;

    MicrosoftMediaInterface(Credential credential, JsonFactory jsonFactory) {
        this.credential = credential;
        this.jsonFactory = jsonFactory;
    }

    MicrosoftDriveItemsResponse getDriveItems(Optional<String> folderId, Optional<String> paginationUrl) throws IOException {
        Object requestUrl;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (paginationUrl.isPresent()) {
            requestUrl = paginationUrl.get();
        } else if (folderId.isPresent()) {
            requestUrl = "https://graph.microsoft.com/v1.0/me/drive/items/" + folderId.get() + "/children";
            params.put(ODATA_TOP, String.valueOf(50));
        } else {
            requestUrl = "https://graph.microsoft.com/v1.0/me/drive/root/children";
            params.put(ODATA_TOP, String.valueOf(50));
        }
        return this.makeGetRequest((String)requestUrl, Optional.of(params), MicrosoftDriveItemsResponse.class);
    }

    MicrosoftDriveItemsResponse getDriveItemsFromSpecialFolder(MicrosoftSpecialFolder.FolderType folderType) throws IOException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(ODATA_TOP, String.valueOf(50));
        return this.makeGetRequest("https://graph.microsoft.com/v1.0/me/drive/special/" + folderType.toString() + "/children", Optional.of(params), MicrosoftDriveItemsResponse.class);
    }

    private <T> T makeGetRequest(String url, Optional<Map<String, String>> parameters, Class<T> tClass) throws IOException {
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory();
        if (parameters.isPresent() && parameters.get().size() > 0) {
            url = (String)url + this.generateODataParams(parameters.get());
        }
        HttpRequest getRequest = requestFactory.buildGetRequest(new GenericUrl((String)url));
        this.setAuthorization(getRequest);
        HttpResponse response = getRequest.execute();
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Bad status code: " + statusCode + " error: " + response.getStatusMessage());
        }
        String result = CharStreams.toString((Readable)new InputStreamReader(response.getContent(), StandardCharsets.UTF_8));
        return (T)this.objectMapper.readValue(result, tClass);
    }

    private void setAuthorization(HttpRequest request) throws IOException {
        if (this.credential.getAccessToken() == null) {
            this.credential.refreshToken();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        headers.setAuthorization("Bearer " + this.credential.getAccessToken());
        request.setHeaders(headers);
    }

    private String generateODataParams(Map<String, String> params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0);
        ArrayList<String> orderedKeys = new ArrayList<String>(params.keySet());
        Collections.sort(orderedKeys);
        ArrayList<CallSite> paramStrings = new ArrayList<CallSite>();
        for (String key : orderedKeys) {
            String k = key.trim();
            String v = params.get(key).trim();
            paramStrings.add((CallSite)((Object)("$" + k + "=" + v)));
        }
        return "?" + String.join((CharSequence)"&", paramStrings);
    }
}

