/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.contacts;

import com.fasterxml.jackson.databind.ObjectMapper;
import ezvcard.io.json.JCardReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.microsoft.common.RequestHelper;
import org.datatransferproject.transfer.microsoft.transformer.TransformResult;
import org.datatransferproject.transfer.microsoft.transformer.TransformerService;
import org.datatransferproject.types.common.models.contacts.ContactsModelWrapper;
import org.datatransferproject.types.transfer.auth.TokenAuthData;

public class MicrosoftContactsImporter
implements Importer<TokenAuthData, ContactsModelWrapper> {
    private static final String CONTACTS_URL = "/me/contacts";
    private final String baseUrl;
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;
    private final TransformerService transformerService;

    public MicrosoftContactsImporter(String baseUrl, OkHttpClient client, ObjectMapper objectMapper, TransformerService transformerService) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.objectMapper = objectMapper;
        this.transformerService = transformerService;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentImportExecutor, TokenAuthData authData, ContactsModelWrapper wrapper) {
        JCardReader reader = new JCardReader(wrapper.getVCards());
        try {
            List cards = reader.readAll();
            ArrayList problems = new ArrayList();
            int[] id = new int[]{1};
            List<Map<String, Object>> requests = cards.stream().map(card -> {
                TransformResult<LinkedHashMap> result = this.transformerService.transform(LinkedHashMap.class, card);
                problems.addAll(result.getProblems());
                LinkedHashMap contact = result.getTransformed();
                Map<String, Object> request = RequestHelper.createRequest(id[0], CONTACTS_URL, contact);
                id[0] = id[0] + 1;
                return request;
            }).collect(Collectors.toList());
            if (!problems.isEmpty()) {
                // empty if block
            }
            return RequestHelper.batchRequest(authData, requests, this.baseUrl, this.client, this.objectMapper).getResult();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ImportResult((Throwable)e);
        }
    }
}

