/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.contacts;

import com.fasterxml.jackson.databind.ObjectMapper;
import ezvcard.VCard;
import ezvcard.io.json.JCardWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.transfer.microsoft.transformer.TransformResult;
import org.datatransferproject.transfer.microsoft.transformer.TransformerService;
import org.datatransferproject.transfer.microsoft.types.GraphPagination;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.contacts.ContactsModelWrapper;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class MicrosoftContactsExporter
implements Exporter<TokensAndUrlAuthData, ContactsModelWrapper> {
    private static final String CONTACTS_SUBPATH = "/v1.0/me/contacts";
    private static final String ODATA_NEXT = "@odata.nextLink";
    private final String contactsUrl;
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;
    private final TransformerService transformerService;

    public MicrosoftContactsExporter(String baseUrl, OkHttpClient client, ObjectMapper objectMapper, TransformerService transformerService) {
        this.contactsUrl = baseUrl + CONTACTS_SUBPATH;
        this.client = client;
        this.objectMapper = objectMapper;
        this.transformerService = transformerService;
    }

    public ExportResult<ContactsModelWrapper> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) {
        GraphPagination graphPagination;
        GraphPagination graphPagination2 = graphPagination = exportInformation.isPresent() ? (GraphPagination)exportInformation.get().getPaginationData() : null;
        if (graphPagination != null && graphPagination.getNextLink() != null) {
            return this.doExport(authData, graphPagination.getNextLink());
        }
        return this.doExport(authData, this.contactsUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExportResult<ContactsModelWrapper> doExport(TokensAndUrlAuthData authData, String url) {
        Request.Builder graphReqBuilder = new Request.Builder().url(url);
        graphReqBuilder.header("Authorization", "Bearer " + authData.getAccessToken());
        try (Response graphResponse = this.client.newCall(graphReqBuilder.build()).execute();){
            ResponseBody body = graphResponse.body();
            if (body == null) {
                ExportResult exportResult = new ExportResult((Throwable)new Exception("Error retrieving contacts: response body was null"));
                return exportResult;
            }
            String graphBody = new String(body.bytes());
            Map graphMap = (Map)this.objectMapper.reader().forType(Map.class).readValue(graphBody);
            String nextLink = (String)graphMap.get(ODATA_NEXT);
            ContinuationData continuationData = nextLink == null ? null : new ContinuationData((PaginationData)new GraphPagination(nextLink));
            List rawContacts = (List)graphMap.get("value");
            if (rawContacts == null) {
                ExportResult exportResult = new ExportResult(ExportResult.ResultType.END);
                return exportResult;
            }
            ContactsModelWrapper wrapper = this.transform(rawContacts);
            ExportResult exportResult = new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)wrapper, continuationData);
            return exportResult;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ExportResult((Throwable)e);
        }
    }

    private ContactsModelWrapper transform(List<Map<String, Object>> rawContacts) {
        StringWriter stringWriter = new StringWriter();
        try (JCardWriter writer = new JCardWriter((Writer)stringWriter);){
            for (Map<String, Object> rawContact : rawContacts) {
                TransformResult<VCard> result = this.transformerService.transform(VCard.class, rawContact);
                if (result.hasProblems()) continue;
                writer.write(result.getTransformed());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ContactsModelWrapper("");
        }
        return new ContactsModelWrapper(stringWriter.toString());
    }
}

